/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.converters;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public final class EraserVisitor {
    public static final EraserVisitor ERASER = new EraserVisitor();

    private EraserVisitor() {
    }

    public final Class visit(Type type) {
        if (type instanceof Class) {
            return this.onClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.onParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.onGenericArray((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            return this.onWildcard((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return this.onVariable((TypeVariable)type);
        }
        throw new RuntimeException("Unexpected type " + type);
    }

    private Class onClass(Class clazz) {
        return clazz;
    }

    private Class onParameterizedType(ParameterizedType type) {
        return this.visit(type.getRawType());
    }

    private Class onGenericArray(GenericArrayType type) {
        return Array.newInstance(this.visit(type.getGenericComponentType()), 0).getClass();
    }

    private Class onVariable(TypeVariable type) {
        return this.visit(type.getBounds()[0]);
    }

    private Class onWildcard(WildcardType type) {
        return this.visit(type.getUpperBounds()[0]);
    }
}

