/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.converters;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.content.ParameterConverter;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.api.content.ParameterFactory;
import org.wisdom.api.http.Context;
import org.wisdom.content.converters.BooleanConverter;
import org.wisdom.content.converters.CharacterConverter;
import org.wisdom.content.converters.ClassTypePair;
import org.wisdom.content.converters.ConstructorBasedConverter;
import org.wisdom.content.converters.FromBasedConverter;
import org.wisdom.content.converters.FromStringBasedConverter;
import org.wisdom.content.converters.ReflectionHelper;
import org.wisdom.content.converters.StringConverter;
import org.wisdom.content.converters.ValueOfBasedConverter;

@Component
@Provides
@Instantiate(name="ParameterConverterEngine")
public class ParamConverterEngine
implements ParameterFactories,
Pojo {
    InstanceManager __IM;
    private boolean __Fconverters;
    @Requires(specification=ParameterConverter.class, optional=true)
    List<ParameterConverter> converters;
    private boolean __Ffactories;
    @Requires(specification=ParameterFactory.class, optional=true)
    List<ParameterFactory> factories;
    boolean __MconvertValue$java_lang_String$java_lang_Class$java_lang_reflect_Type$java_lang_String;
    boolean __MgetMultipleValues$java_lang_String$java_lang_String;
    boolean __MconvertValues$java_util_Collection$java_lang_Class$java_lang_reflect_Type$java_lang_String;
    boolean __MnewInstance$org_wisdom_api_http_Context$java_lang_Class;
    boolean __MgetTypesHandledByFactories;
    boolean __McreateCollection$java_util_Collection$java_lang_Class$java_lang_reflect_Type;
    boolean __McreateCollectionWithConverter$java_util_Collection$java_lang_Class$org_wisdom_api_content_ParameterConverter;
    boolean __McreateArray$java_util_Collection$java_lang_Class;
    boolean __MconvertSingleValue$java_lang_String$java_lang_Class$java_lang_String;
    boolean __MconvertSingleValue$java_util_Collection$java_lang_Class$java_lang_String;
    boolean __MgetConverter$java_lang_Class;

    List __getconverters() {
        if (!this.__Fconverters) {
            return this.converters;
        }
        return (List)this.__IM.onGet((Object)this, "converters");
    }

    void __setconverters(List list) {
        if (!this.__Fconverters) {
            this.converters = list;
            return;
        }
        this.__IM.onSet((Object)this, "converters", (Object)list);
    }

    List __getfactories() {
        if (!this.__Ffactories) {
            return this.factories;
        }
        return (List)this.__IM.onGet((Object)this, "factories");
    }

    void __setfactories(List list) {
        if (!this.__Ffactories) {
            this.factories = list;
            return;
        }
        this.__IM.onSet((Object)this, "factories", (Object)list);
    }

    public ParamConverterEngine() {
        this(null);
    }

    private ParamConverterEngine(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public ParamConverterEngine(List<ParameterConverter> conv, List<ParameterFactory> fact) {
        this(null, conv, fact);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private ParamConverterEngine(InstanceManager _manager, List conv, List fact) {
        this._setInstanceManager(_manager);
        this.__setconverters(conv);
        this.__setfactories(fact);
    }

    public <T> T convertValue(String input, Class<T> rawType, Type type, String defaultValue) throws IllegalArgumentException {
        T t;
        if (!this.__MconvertValue$java_lang_String$java_lang_Class$java_lang_reflect_Type$java_lang_String) {
            return this.__M_convertValue(input, rawType, type, defaultValue);
        }
        try {
            this.__IM.onEntry((Object)this, "convertValue$java_lang_String$java_lang_Class$java_lang_reflect_Type$java_lang_String", new Object[]{input, rawType, type, defaultValue});
            t = this.__M_convertValue(input, rawType, type, defaultValue);
            this.__IM.onExit((Object)this, "convertValue$java_lang_String$java_lang_Class$java_lang_reflect_Type$java_lang_String", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertValue$java_lang_String$java_lang_Class$java_lang_reflect_Type$java_lang_String", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_convertValue(String input, Class<T> rawType, Type type, String defaultValue) throws IllegalArgumentException {
        if (rawType.isArray()) {
            List<String> args = this.getMultipleValues(input, defaultValue);
            return this.createArray(args, rawType.getComponentType());
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            List<String> args = this.getMultipleValues(input, defaultValue);
            return this.createCollection(args, rawType, type);
        }
        return this.convertSingleValue(input, rawType, defaultValue);
    }

    private List<String> getMultipleValues(String input, String defaultValue) {
        List<String> list;
        if (!this.__MgetMultipleValues$java_lang_String$java_lang_String) {
            return this.__M_getMultipleValues(input, defaultValue);
        }
        try {
            this.__IM.onEntry((Object)this, "getMultipleValues$java_lang_String$java_lang_String", new Object[]{input, defaultValue});
            list = this.__M_getMultipleValues(input, defaultValue);
            this.__IM.onExit((Object)this, "getMultipleValues$java_lang_String$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMultipleValues$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getMultipleValues(String input, String defaultValue) {
        if (input == null && defaultValue == null) {
            return null;
        }
        if (input == null) {
            input = defaultValue;
        }
        String[] segments = input.split(",");
        ArrayList<String> values = new ArrayList<String>();
        for (String s : segments) {
            String v = s.trim();
            if (v.isEmpty()) continue;
            values.add(v);
        }
        return values;
    }

    public <T> T convertValues(Collection<String> input, Class<T> rawType, Type type, String defaultValue) throws IllegalArgumentException {
        T t;
        if (!this.__MconvertValues$java_util_Collection$java_lang_Class$java_lang_reflect_Type$java_lang_String) {
            return this.__M_convertValues(input, rawType, type, defaultValue);
        }
        try {
            this.__IM.onEntry((Object)this, "convertValues$java_util_Collection$java_lang_Class$java_lang_reflect_Type$java_lang_String", new Object[]{input, rawType, type, defaultValue});
            t = this.__M_convertValues(input, rawType, type, defaultValue);
            this.__IM.onExit((Object)this, "convertValues$java_util_Collection$java_lang_Class$java_lang_reflect_Type$java_lang_String", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertValues$java_util_Collection$java_lang_Class$java_lang_reflect_Type$java_lang_String", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_convertValues(Collection<String> input, Class<T> rawType, Type type, String defaultValue) throws IllegalArgumentException {
        if (rawType.isArray()) {
            if (input == null) {
                input = this.getMultipleValues(defaultValue, null);
            }
            return this.createArray(input, rawType.getComponentType());
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            if (input == null) {
                input = this.getMultipleValues(defaultValue, null);
            }
            return this.createCollection(input, rawType, type);
        }
        return this.convertSingleValue(input, rawType, defaultValue);
    }

    public <T> T newInstance(Context context, Class<T> type) throws IllegalArgumentException {
        T t;
        if (!this.__MnewInstance$org_wisdom_api_http_Context$java_lang_Class) {
            return this.__M_newInstance(context, type);
        }
        try {
            this.__IM.onEntry((Object)this, "newInstance$org_wisdom_api_http_Context$java_lang_Class", new Object[]{context, type});
            t = this.__M_newInstance(context, type);
            this.__IM.onExit((Object)this, "newInstance$org_wisdom_api_http_Context$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "newInstance$org_wisdom_api_http_Context$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_newInstance(Context context, Class<T> type) throws IllegalArgumentException {
        for (ParameterFactory factory : this.__getfactories()) {
            if (!factory.getType().equals(type)) continue;
            return (T)factory.newInstance(context);
        }
        throw new IllegalArgumentException("Unable to find a ParameterFactory able to create instance of " + type.getName());
    }

    public Set<Class> getTypesHandledByFactories() {
        Set<Class> set;
        if (!this.__MgetTypesHandledByFactories) {
            return this.__M_getTypesHandledByFactories();
        }
        try {
            this.__IM.onEntry((Object)this, "getTypesHandledByFactories", new Object[0]);
            set = this.__M_getTypesHandledByFactories();
            this.__IM.onExit((Object)this, "getTypesHandledByFactories", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTypesHandledByFactories", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<Class> __M_getTypesHandledByFactories() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ParameterFactory factory : this.__getfactories()) {
            builder.add((Object)factory.getType());
        }
        return builder.build();
    }

    private <T> T createCollection(Collection<String> input, Class<T> rawType, Type type) {
        T t;
        if (!this.__McreateCollection$java_util_Collection$java_lang_Class$java_lang_reflect_Type) {
            return this.__M_createCollection(input, rawType, type);
        }
        try {
            this.__IM.onEntry((Object)this, "createCollection$java_util_Collection$java_lang_Class$java_lang_reflect_Type", new Object[]{input, rawType, type});
            t = this.__M_createCollection(input, rawType, type);
            this.__IM.onExit((Object)this, "createCollection$java_util_Collection$java_lang_Class$java_lang_reflect_Type", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createCollection$java_util_Collection$java_lang_Class$java_lang_reflect_Type", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_createCollection(Collection<String> input, Class<T> rawType, Type type) {
        ClassTypePair ctp;
        List<ClassTypePair> ctps = ReflectionHelper.getTypeArgumentAndClass(type);
        ClassTypePair classTypePair = ctp = ctps.size() == 1 ? ctps.get(0) : null;
        if (ctp == null || ctp.rawClass() == String.class) {
            return this.createCollectionWithConverter(input, rawType, StringConverter.INSTANCE);
        }
        ParameterConverter converter = this.getConverter(ctp.rawClass());
        return this.createCollectionWithConverter(input, rawType, converter);
    }

    private <T, A> T createCollectionWithConverter(Collection<String> input, Class<T> type, ParameterConverter<A> converter) {
        T t;
        if (!this.__McreateCollectionWithConverter$java_util_Collection$java_lang_Class$org_wisdom_api_content_ParameterConverter) {
            return this.__M_createCollectionWithConverter(input, type, converter);
        }
        try {
            this.__IM.onEntry((Object)this, "createCollectionWithConverter$java_util_Collection$java_lang_Class$org_wisdom_api_content_ParameterConverter", new Object[]{input, type, converter});
            t = this.__M_createCollectionWithConverter(input, type, converter);
            this.__IM.onExit((Object)this, "createCollectionWithConverter$java_util_Collection$java_lang_Class$org_wisdom_api_content_ParameterConverter", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createCollectionWithConverter$java_util_Collection$java_lang_Class$org_wisdom_api_content_ParameterConverter", throwable);
            throw throwable;
        }
        return t;
    }

    private <T, A> T __M_createCollectionWithConverter(Collection<String> input, Class<T> type, ParameterConverter<A> converter) {
        AbstractCollection collection;
        if (type == Collection.class || List.class.isAssignableFrom(type)) {
            if (input == null) {
                return type.cast(Collections.emptyList());
            }
            collection = new ArrayList();
        } else if (Set.class.isAssignableFrom(type)) {
            if (input == null) {
                return type.cast(Collections.emptySet());
            }
            collection = new LinkedHashSet();
        } else {
            throw new IllegalArgumentException("Not supported collection type " + type.getName());
        }
        for (String v : input) {
            collection.add(converter.fromString(v));
        }
        return type.cast(collection);
    }

    private <T> T createArray(Collection<String> input, Class<?> componentType) {
        T t;
        if (!this.__McreateArray$java_util_Collection$java_lang_Class) {
            return this.__M_createArray(input, componentType);
        }
        try {
            this.__IM.onEntry((Object)this, "createArray$java_util_Collection$java_lang_Class", new Object[]{input, componentType});
            t = this.__M_createArray(input, componentType);
            this.__IM.onExit((Object)this, "createArray$java_util_Collection$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createArray$java_util_Collection$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_createArray(Collection<String> input, Class<?> componentType) {
        if (input == null) {
            return (T)Array.newInstance(componentType, 0);
        }
        Class theType = componentType;
        if (componentType.isPrimitive()) {
            theType = Primitives.wrap((Class)componentType);
        }
        ParameterConverter<T> converter = this.getConverter(theType);
        ArrayList<Object> list = new ArrayList<Object>();
        for (String v : input) {
            list.add(converter.fromString(v));
        }
        Object array = Array.newInstance(componentType, list.size());
        int i = 0;
        for (Object e : list) {
            Array.set(array, i, e);
            ++i;
        }
        return (T)array;
    }

    private <T> T convertSingleValue(String input, Class<T> type, String defaultValue) {
        T t;
        if (!this.__MconvertSingleValue$java_lang_String$java_lang_Class$java_lang_String) {
            return this.__M_convertSingleValue(input, type, defaultValue);
        }
        try {
            this.__IM.onEntry((Object)this, "convertSingleValue$java_lang_String$java_lang_Class$java_lang_String", new Object[]{input, type, defaultValue});
            t = this.__M_convertSingleValue(input, type, defaultValue);
            this.__IM.onExit((Object)this, "convertSingleValue$java_lang_String$java_lang_Class$java_lang_String", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertSingleValue$java_lang_String$java_lang_Class$java_lang_String", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_convertSingleValue(String input, Class<T> type, String defaultValue) {
        if (type.isPrimitive()) {
            type = Primitives.wrap(type);
            if (input == null && defaultValue == null) {
                defaultValue = ReflectionHelper.getPrimitiveDefault(type);
            }
        }
        ParameterConverter<T> converter = this.getConverter(type);
        if (input != null) {
            return (T)converter.fromString(input);
        }
        return (T)converter.fromString(defaultValue);
    }

    private <T> T convertSingleValue(Collection<String> input, Class<T> type, String defaultValue) {
        T t;
        if (!this.__MconvertSingleValue$java_util_Collection$java_lang_Class$java_lang_String) {
            return this.__M_convertSingleValue(input, type, defaultValue);
        }
        try {
            this.__IM.onEntry((Object)this, "convertSingleValue$java_util_Collection$java_lang_Class$java_lang_String", new Object[]{input, type, defaultValue});
            t = this.__M_convertSingleValue(input, type, defaultValue);
            this.__IM.onExit((Object)this, "convertSingleValue$java_util_Collection$java_lang_Class$java_lang_String", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertSingleValue$java_util_Collection$java_lang_Class$java_lang_String", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_convertSingleValue(Collection<String> input, Class<T> type, String defaultValue) {
        if (input == null || input.isEmpty()) {
            return this.convertSingleValue((String)null, type, defaultValue);
        }
        String v = input.iterator().next();
        return this.convertSingleValue(v, type, defaultValue);
    }

    private <T> ParameterConverter<T> getConverter(Class<T> type) {
        ParameterConverter<T> parameterConverter;
        if (!this.__MgetConverter$java_lang_Class) {
            return this.__M_getConverter(type);
        }
        try {
            this.__IM.onEntry((Object)this, "getConverter$java_lang_Class", new Object[]{type});
            parameterConverter = this.__M_getConverter(type);
            this.__IM.onExit((Object)this, "getConverter$java_lang_Class", parameterConverter);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConverter$java_lang_Class", throwable);
            throw throwable;
        }
        return parameterConverter;
    }

    private <T> ParameterConverter<T> __M_getConverter(Class<T> type) {
        if (type == String.class) {
            return StringConverter.INSTANCE;
        }
        for (ParameterConverter pc : this.__getconverters()) {
            if (!pc.getType().equals(type)) continue;
            return pc;
        }
        if (type == Boolean.class) {
            return BooleanConverter.INSTANCE;
        }
        Object converter = ConstructorBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = ValueOfBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = FromBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        converter = FromStringBasedConverter.getIfEligible(type);
        if (converter != null) {
            return converter;
        }
        if (type == Character.class) {
            return CharacterConverter.INSTANCE;
        }
        throw new NoSuchElementException("Cannot find a converter able to create instance of " + type.getName());
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("converters")) {
                this.__Fconverters = true;
            }
            if (set.contains("factories")) {
                this.__Ffactories = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("convertValue$java_lang_String$java_lang_Class$java_lang_reflect_Type$java_lang_String")) {
                this.__MconvertValue$java_lang_String$java_lang_Class$java_lang_reflect_Type$java_lang_String = true;
            }
            if (set.contains("getMultipleValues$java_lang_String$java_lang_String")) {
                this.__MgetMultipleValues$java_lang_String$java_lang_String = true;
            }
            if (set.contains("convertValues$java_util_Collection$java_lang_Class$java_lang_reflect_Type$java_lang_String")) {
                this.__MconvertValues$java_util_Collection$java_lang_Class$java_lang_reflect_Type$java_lang_String = true;
            }
            if (set.contains("newInstance$org_wisdom_api_http_Context$java_lang_Class")) {
                this.__MnewInstance$org_wisdom_api_http_Context$java_lang_Class = true;
            }
            if (set.contains("getTypesHandledByFactories")) {
                this.__MgetTypesHandledByFactories = true;
            }
            if (set.contains("createCollection$java_util_Collection$java_lang_Class$java_lang_reflect_Type")) {
                this.__McreateCollection$java_util_Collection$java_lang_Class$java_lang_reflect_Type = true;
            }
            if (set.contains("createCollectionWithConverter$java_util_Collection$java_lang_Class$org_wisdom_api_content_ParameterConverter")) {
                this.__McreateCollectionWithConverter$java_util_Collection$java_lang_Class$org_wisdom_api_content_ParameterConverter = true;
            }
            if (set.contains("createArray$java_util_Collection$java_lang_Class")) {
                this.__McreateArray$java_util_Collection$java_lang_Class = true;
            }
            if (set.contains("convertSingleValue$java_lang_String$java_lang_Class$java_lang_String")) {
                this.__MconvertSingleValue$java_lang_String$java_lang_Class$java_lang_String = true;
            }
            if (set.contains("convertSingleValue$java_util_Collection$java_lang_Class$java_lang_String")) {
                this.__MconvertSingleValue$java_util_Collection$java_lang_Class$java_lang_String = true;
            }
            if (set.contains("getConverter$java_lang_Class")) {
                this.__MgetConverter$java_lang_Class = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

