/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.api.content.JacksonModuleRepository;
import org.wisdom.api.content.Json;
import org.wisdom.api.content.Xml;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component(immediate=true)
@Provides
@Instantiate
public class JacksonSingleton
implements JacksonModuleRepository,
Json,
Xml,
Pojo {
    InstanceManager __IM;
    private boolean __Flock;
    private final Object lock;
    private boolean __Fmapper;
    private ObjectMapper mapper;
    private boolean __Fxml;
    private XmlMapper xml;
    private boolean __Ffactory;
    private DocumentBuilderFactory factory;
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonSingleton.class);
    private boolean __Fmodules;
    private Set<Module> modules;
    private boolean __Fconfiguration;
    @Requires
    public ApplicationConfiguration configuration;
    boolean __Mmapper;
    boolean __MtoJson$java_lang_Object;
    boolean __MtoJsonP$java_lang_String$java_lang_Object;
    boolean __MfromJson$com_fasterxml_jackson_databind_JsonNode$java_lang_Class;
    boolean __MfromJson$java_lang_String$java_lang_Class;
    boolean __Mstringify$com_fasterxml_jackson_databind_JsonNode;
    boolean __Mparse$java_lang_String;
    boolean __Mparse$java_io_InputStream;
    boolean __MnewObject;
    boolean __MnewArray;
    boolean __Mvalidate;
    boolean __MsetMappers$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper;
    boolean __MapplyMapperConfiguration$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper;
    boolean __MsetFeature$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper$java_lang_String$java_lang_Boolean;
    boolean __Minvalidate;
    boolean __Mregister$com_fasterxml_jackson_databind_Module;
    boolean __MrebuildMappers;
    boolean __Munregister$com_fasterxml_jackson_databind_Module;
    boolean __MxmlMapper;
    boolean __MfromString$java_lang_String;
    boolean __MfromInputStream$java_io_InputStream$java_nio_charset_Charset;
    boolean __MfromXML$org_w3c_dom_Document$java_lang_Class;
    boolean __MfromXML$java_lang_String$java_lang_Class;
    boolean __Mstringify$org_w3c_dom_Document;
    boolean __MnewDocument;
    boolean __MbindModule$com_fasterxml_jackson_databind_Module;
    boolean __MunbindModule$com_fasterxml_jackson_databind_Module;

    Object __getlock() {
        if (!this.__Flock) {
            return this.lock;
        }
        return this.__IM.onGet((Object)this, "lock");
    }

    void __setlock(Object object) {
        if (!this.__Flock) {
            this.lock = object;
            return;
        }
        this.__IM.onSet((Object)this, "lock", object);
    }

    ObjectMapper __getmapper() {
        if (!this.__Fmapper) {
            return this.mapper;
        }
        return (ObjectMapper)this.__IM.onGet((Object)this, "mapper");
    }

    void __setmapper(ObjectMapper objectMapper) {
        if (!this.__Fmapper) {
            this.mapper = objectMapper;
            return;
        }
        this.__IM.onSet((Object)this, "mapper", (Object)objectMapper);
    }

    XmlMapper __getxml() {
        if (!this.__Fxml) {
            return this.xml;
        }
        return (XmlMapper)this.__IM.onGet((Object)this, "xml");
    }

    void __setxml(XmlMapper xmlMapper) {
        if (!this.__Fxml) {
            this.xml = xmlMapper;
            return;
        }
        this.__IM.onSet((Object)this, "xml", (Object)xmlMapper);
    }

    DocumentBuilderFactory __getfactory() {
        if (!this.__Ffactory) {
            return this.factory;
        }
        return (DocumentBuilderFactory)this.__IM.onGet((Object)this, "factory");
    }

    void __setfactory(DocumentBuilderFactory documentBuilderFactory) {
        if (!this.__Ffactory) {
            this.factory = documentBuilderFactory;
            return;
        }
        this.__IM.onSet((Object)this, "factory", (Object)documentBuilderFactory);
    }

    Set __getmodules() {
        if (!this.__Fmodules) {
            return this.modules;
        }
        return (Set)this.__IM.onGet((Object)this, "modules");
    }

    void __setmodules(Set set) {
        if (!this.__Fmodules) {
            this.modules = set;
            return;
        }
        this.__IM.onSet((Object)this, "modules", (Object)set);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    public JacksonSingleton() {
        this(null);
    }

    private JacksonSingleton(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlock(new Object());
        this.__setfactory(DocumentBuilderFactory.newInstance());
        this.__setmodules(new HashSet());
        try {
            this.__getfactory().setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Cannot use secure processing for XML document", (Throwable)e);
        }
    }

    public ObjectMapper mapper() {
        ObjectMapper objectMapper;
        if (!this.__Mmapper) {
            return this.__M_mapper();
        }
        try {
            this.__IM.onEntry((Object)this, "mapper", new Object[0]);
            objectMapper = this.__M_mapper();
            this.__IM.onExit((Object)this, "mapper", (Object)objectMapper);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "mapper", throwable);
            throw throwable;
        }
        return objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper __M_mapper() {
        Object object = this.__getlock();
        synchronized (object) {
            return this.__getmapper();
        }
    }

    public JsonNode toJson(Object data) {
        JsonNode jsonNode;
        if (!this.__MtoJson$java_lang_Object) {
            return this.__M_toJson(data);
        }
        try {
            this.__IM.onEntry((Object)this, "toJson$java_lang_Object", new Object[]{data});
            jsonNode = this.__M_toJson(data);
            this.__IM.onExit((Object)this, "toJson$java_lang_Object", (Object)jsonNode);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toJson$java_lang_Object", throwable);
            throw throwable;
        }
        return jsonNode;
    }

    private JsonNode __M_toJson(Object data) {
        Object object = this.__getlock();
        synchronized (object) {
            try {
                return this.__getmapper().valueToTree(data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toJsonP(String callback, Object data) {
        String string;
        if (!this.__MtoJsonP$java_lang_String$java_lang_Object) {
            return this.__M_toJsonP(callback, data);
        }
        try {
            this.__IM.onEntry((Object)this, "toJsonP$java_lang_String$java_lang_Object", new Object[]{callback, data});
            string = this.__M_toJsonP(callback, data);
            this.__IM.onExit((Object)this, "toJsonP$java_lang_String$java_lang_Object", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toJsonP$java_lang_String$java_lang_Object", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_toJsonP(String callback, Object data) {
        Object object = this.__getlock();
        synchronized (object) {
            try {
                return callback + "(" + this.stringify(this.__getmapper().valueToTree(data)) + ");";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <A> A fromJson(JsonNode json, Class<A> clazz) {
        A a;
        if (!this.__MfromJson$com_fasterxml_jackson_databind_JsonNode$java_lang_Class) {
            return this.__M_fromJson(json, clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "fromJson$com_fasterxml_jackson_databind_JsonNode$java_lang_Class", new Object[]{json, clazz});
            a = this.__M_fromJson(json, clazz);
            this.__IM.onExit((Object)this, "fromJson$com_fasterxml_jackson_databind_JsonNode$java_lang_Class", a);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromJson$com_fasterxml_jackson_databind_JsonNode$java_lang_Class", throwable);
            throw throwable;
        }
        return a;
    }

    private <A> A __M_fromJson(JsonNode json, Class<A> clazz) {
        Object object = this.__getlock();
        synchronized (object) {
            try {
                return (A)this.__getmapper().treeToValue((TreeNode)json, clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <A> A fromJson(String json, Class<A> clazz) {
        A a;
        if (!this.__MfromJson$java_lang_String$java_lang_Class) {
            return this.__M_fromJson(json, clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "fromJson$java_lang_String$java_lang_Class", new Object[]{json, clazz});
            a = this.__M_fromJson(json, clazz);
            this.__IM.onExit((Object)this, "fromJson$java_lang_String$java_lang_Class", a);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromJson$java_lang_String$java_lang_Class", throwable);
            throw throwable;
        }
        return a;
    }

    private <A> A __M_fromJson(String json, Class<A> clazz) {
        Object object = this.__getlock();
        synchronized (object) {
            try {
                JsonNode node = this.__getmapper().readTree(json);
                return (A)this.__getmapper().treeToValue((TreeNode)node, clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String stringify(JsonNode json) {
        String string;
        if (!this.__Mstringify$com_fasterxml_jackson_databind_JsonNode) {
            return this.__M_stringify(json);
        }
        try {
            this.__IM.onEntry((Object)this, "stringify$com_fasterxml_jackson_databind_JsonNode", new Object[]{json});
            string = this.__M_stringify(json);
            this.__IM.onExit((Object)this, "stringify$com_fasterxml_jackson_databind_JsonNode", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stringify$com_fasterxml_jackson_databind_JsonNode", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_stringify(JsonNode json) {
        try {
            return this.mapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot stringify the input json node", e);
        }
    }

    public JsonNode parse(String src) {
        JsonNode jsonNode;
        if (!this.__Mparse$java_lang_String) {
            return this.__M_parse(src);
        }
        try {
            this.__IM.onEntry((Object)this, "parse$java_lang_String", new Object[]{src});
            jsonNode = this.__M_parse(src);
            this.__IM.onExit((Object)this, "parse$java_lang_String", (Object)jsonNode);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "parse$java_lang_String", throwable);
            throw throwable;
        }
        return jsonNode;
    }

    private JsonNode __M_parse(String src) {
        Object object = this.__getlock();
        synchronized (object) {
            try {
                return (JsonNode)this.__getmapper().readValue(src, JsonNode.class);
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }
    }

    public JsonNode parse(InputStream stream) {
        JsonNode jsonNode;
        if (!this.__Mparse$java_io_InputStream) {
            return this.__M_parse(stream);
        }
        try {
            this.__IM.onEntry((Object)this, "parse$java_io_InputStream", new Object[]{stream});
            jsonNode = this.__M_parse(stream);
            this.__IM.onExit((Object)this, "parse$java_io_InputStream", (Object)jsonNode);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "parse$java_io_InputStream", throwable);
            throw throwable;
        }
        return jsonNode;
    }

    private JsonNode __M_parse(InputStream stream) {
        Object object = this.__getlock();
        synchronized (object) {
            try {
                return (JsonNode)this.__getmapper().readValue(stream, JsonNode.class);
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }
    }

    public ObjectNode newObject() {
        ObjectNode objectNode;
        if (!this.__MnewObject) {
            return this.__M_newObject();
        }
        try {
            this.__IM.onEntry((Object)this, "newObject", new Object[0]);
            objectNode = this.__M_newObject();
            this.__IM.onExit((Object)this, "newObject", (Object)objectNode);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "newObject", throwable);
            throw throwable;
        }
        return objectNode;
    }

    private ObjectNode __M_newObject() {
        return this.mapper().createObjectNode();
    }

    public ArrayNode newArray() {
        ArrayNode arrayNode;
        if (!this.__MnewArray) {
            return this.__M_newArray();
        }
        try {
            this.__IM.onEntry((Object)this, "newArray", new Object[0]);
            arrayNode = this.__M_newArray();
            this.__IM.onExit((Object)this, "newArray", (Object)arrayNode);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "newArray", throwable);
            throw throwable;
        }
        return arrayNode;
    }

    private ArrayNode __M_newArray() {
        return this.mapper().createArrayNode();
    }

    public void validate() {
        if (!this.__Mvalidate) {
            this.__M_validate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate", new Object[0]);
            this.__M_validate();
            this.__IM.onExit((Object)this, "validate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_validate() {
        LOGGER.info("Starting JSON and XML support services");
        this.setMappers(new ObjectMapper(), new XmlMapper());
    }

    private void setMappers(ObjectMapper mapper, XmlMapper xml) {
        if (!this.__MsetMappers$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper) {
            this.__M_setMappers(mapper, xml);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMappers$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper", new Object[]{mapper, xml});
            this.__M_setMappers(mapper, xml);
            this.__IM.onExit((Object)this, "setMappers$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMappers$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_setMappers(ObjectMapper mapper, XmlMapper xml) {
        Object object = this.__getlock();
        synchronized (object) {
            this.__setmapper(mapper);
            this.__setxml(xml);
            if (mapper != null && xml != null) {
                this.applyMapperConfiguration(mapper, xml);
            }
        }
    }

    private void applyMapperConfiguration(ObjectMapper mapper, XmlMapper xml) {
        if (!this.__MapplyMapperConfiguration$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper) {
            this.__M_applyMapperConfiguration(mapper, xml);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "applyMapperConfiguration$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper", new Object[]{mapper, xml});
            this.__M_applyMapperConfiguration(mapper, xml);
            this.__IM.onExit((Object)this, "applyMapperConfiguration$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "applyMapperConfiguration$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper", throwable);
            throw throwable;
        }
    }

    private void __M_applyMapperConfiguration(ObjectMapper mapper, XmlMapper xml) {
        Configuration conf = null;
        if (this.__getconfiguration() != null) {
            conf = this.__getconfiguration().getConfiguration("jackson");
        }
        if (conf == null) {
            LOGGER.info("Using default (Wisdom) configuration of Jackson");
            LOGGER.info("FAIL_ON_UNKNOWN_PROPERTIES is disabled");
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            xml.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        } else {
            LOGGER.info("Applying custom configuration on Jackson mapper");
            Set keys = conf.asMap().keySet();
            for (String key : keys) {
                this.setFeature(mapper, xml, key, conf.getBoolean(key));
            }
        }
    }

    private void setFeature(ObjectMapper mapper, XmlMapper xml, String key, Boolean value) {
        if (!this.__MsetFeature$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper$java_lang_String$java_lang_Boolean) {
            this.__M_setFeature(mapper, xml, key, value);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setFeature$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper$java_lang_String$java_lang_Boolean", new Object[]{mapper, xml, key, value});
            this.__M_setFeature(mapper, xml, key, value);
            this.__IM.onExit((Object)this, "setFeature$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper$java_lang_String$java_lang_Boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setFeature$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper$java_lang_String$java_lang_Boolean", throwable);
            throw throwable;
        }
    }

    private void __M_setFeature(ObjectMapper mapper, XmlMapper xml, String key, Boolean value) {
        try {
            MapperFeature feature = MapperFeature.valueOf((String)key);
            mapper.configure(feature, value.booleanValue());
            xml.configure(feature, value.booleanValue());
            return;
        }
        catch (IllegalArgumentException e) {
            try {
                DeserializationFeature feature = DeserializationFeature.valueOf((String)key);
                mapper.configure(feature, value.booleanValue());
                xml.configure(feature, value.booleanValue());
                return;
            }
            catch (IllegalArgumentException e2) {
                try {
                    SerializationFeature feature = SerializationFeature.valueOf((String)key);
                    mapper.configure(feature, value.booleanValue());
                    xml.configure(feature, value.booleanValue());
                    return;
                }
                catch (IllegalArgumentException e3) {
                    try {
                        JsonParser.Feature feature = JsonParser.Feature.valueOf((String)key);
                        mapper.configure(feature, value.booleanValue());
                        xml.configure(feature, value.booleanValue());
                        return;
                    }
                    catch (IllegalArgumentException e4) {
                        try {
                            JsonGenerator.Feature feature = JsonGenerator.Feature.valueOf((String)key);
                            mapper.configure(feature, value.booleanValue());
                            xml.configure(feature, value.booleanValue());
                            return;
                        }
                        catch (IllegalArgumentException e5) {
                            throw new IllegalArgumentException("Cannot find a feature with the following name : " + key);
                        }
                    }
                }
            }
        }
    }

    public void invalidate() {
        if (!this.__Minvalidate) {
            this.__M_invalidate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "invalidate", new Object[0]);
            this.__M_invalidate();
            this.__IM.onExit((Object)this, "invalidate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invalidate", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_invalidate() {
        this.setMappers(null, null);
    }

    public void register(Module module) {
        if (!this.__Mregister$com_fasterxml_jackson_databind_Module) {
            this.__M_register(module);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "register$com_fasterxml_jackson_databind_Module", new Object[]{module});
            this.__M_register(module);
            this.__IM.onExit((Object)this, "register$com_fasterxml_jackson_databind_Module", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "register$com_fasterxml_jackson_databind_Module", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_register(Module module) {
        if (module == null) {
            return;
        }
        LOGGER.info("Adding JSON module {}", (Object)module.getModuleName());
        Object object = this.__getlock();
        synchronized (object) {
            this.__getmodules().add(module);
            this.rebuildMappers();
        }
    }

    private void rebuildMappers() {
        if (!this.__MrebuildMappers) {
            this.__M_rebuildMappers();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "rebuildMappers", new Object[0]);
            this.__M_rebuildMappers();
            this.__IM.onExit((Object)this, "rebuildMappers", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "rebuildMappers", throwable);
            throw throwable;
        }
    }

    private void __M_rebuildMappers() {
        this.__setmapper(new ObjectMapper());
        for (Module module : this.__getmodules()) {
            this.__getmapper().registerModule(module);
        }
        this.__setxml(new XmlMapper());
        for (Module module : this.__getmodules()) {
            this.__getxml().registerModule(module);
        }
        this.applyMapperConfiguration(this.__getmapper(), this.__getxml());
    }

    public void unregister(Module module) {
        if (!this.__Munregister$com_fasterxml_jackson_databind_Module) {
            this.__M_unregister(module);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregister$com_fasterxml_jackson_databind_Module", new Object[]{module});
            this.__M_unregister(module);
            this.__IM.onExit((Object)this, "unregister$com_fasterxml_jackson_databind_Module", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregister$com_fasterxml_jackson_databind_Module", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_unregister(Module module) {
        if (module == null) {
            return;
        }
        LOGGER.info("Removing Jackson module {}", (Object)module.getModuleName());
        Object object = this.__getlock();
        synchronized (object) {
            if (this.__getmodules().remove(module)) {
                this.rebuildMappers();
            }
        }
    }

    public XmlMapper xmlMapper() {
        XmlMapper xmlMapper;
        if (!this.__MxmlMapper) {
            return this.__M_xmlMapper();
        }
        try {
            this.__IM.onEntry((Object)this, "xmlMapper", new Object[0]);
            xmlMapper = this.__M_xmlMapper();
            this.__IM.onExit((Object)this, "xmlMapper", (Object)xmlMapper);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "xmlMapper", throwable);
            throw throwable;
        }
        return xmlMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlMapper __M_xmlMapper() {
        Object object = this.__getlock();
        synchronized (object) {
            return this.__getxml();
        }
    }

    public Document fromString(String xml) throws IOException {
        Document document;
        if (!this.__MfromString$java_lang_String) {
            return this.__M_fromString(xml);
        }
        try {
            this.__IM.onEntry((Object)this, "fromString$java_lang_String", new Object[]{xml});
            document = this.__M_fromString(xml);
            this.__IM.onExit((Object)this, "fromString$java_lang_String", (Object)document);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromString$java_lang_String", throwable);
            throw throwable;
        }
        return document;
    }

    private Document __M_fromString(String xml) throws IOException {
        Document document;
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8));
            document = this.fromInputStream(stream, Charsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return document;
    }

    public Document fromInputStream(InputStream stream, Charset encoding) throws IOException {
        Document document;
        if (!this.__MfromInputStream$java_io_InputStream$java_nio_charset_Charset) {
            return this.__M_fromInputStream(stream, encoding);
        }
        try {
            this.__IM.onEntry((Object)this, "fromInputStream$java_io_InputStream$java_nio_charset_Charset", new Object[]{stream, encoding});
            document = this.__M_fromInputStream(stream, encoding);
            this.__IM.onExit((Object)this, "fromInputStream$java_io_InputStream$java_nio_charset_Charset", (Object)document);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromInputStream$java_io_InputStream$java_nio_charset_Charset", throwable);
            throw throwable;
        }
        return document;
    }

    private Document __M_fromInputStream(InputStream stream, Charset encoding) throws IOException {
        try {
            DocumentBuilder builder = this.__getfactory().newDocumentBuilder();
            InputSource is = new InputSource(stream);
            if (encoding == null) {
                is.setEncoding(Charsets.UTF_8.name());
            } else {
                is.setEncoding(encoding.name());
            }
            return builder.parse(is);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot parse the given XML document", e);
        }
    }

    public <A> A fromXML(Document document, Class<A> clazz) {
        A a;
        if (!this.__MfromXML$org_w3c_dom_Document$java_lang_Class) {
            return this.__M_fromXML(document, clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "fromXML$org_w3c_dom_Document$java_lang_Class", new Object[]{document, clazz});
            a = this.__M_fromXML(document, clazz);
            this.__IM.onExit((Object)this, "fromXML$org_w3c_dom_Document$java_lang_Class", a);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromXML$org_w3c_dom_Document$java_lang_Class", throwable);
            throw throwable;
        }
        return a;
    }

    private <A> A __M_fromXML(Document document, Class<A> clazz) {
        return this.fromXML(this.stringify(document), clazz);
    }

    public <A> A fromXML(String xml, Class<A> clazz) {
        A a;
        if (!this.__MfromXML$java_lang_String$java_lang_Class) {
            return this.__M_fromXML(xml, clazz);
        }
        try {
            this.__IM.onEntry((Object)this, "fromXML$java_lang_String$java_lang_Class", new Object[]{xml, clazz});
            a = this.__M_fromXML(xml, clazz);
            this.__IM.onExit((Object)this, "fromXML$java_lang_String$java_lang_Class", a);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromXML$java_lang_String$java_lang_Class", throwable);
            throw throwable;
        }
        return a;
    }

    private <A> A __M_fromXML(String xml, Class<A> clazz) {
        try {
            return (A)this.xmlMapper().readValue(xml, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String stringify(Document document) {
        String string;
        if (!this.__Mstringify$org_w3c_dom_Document) {
            return this.__M_stringify(document);
        }
        try {
            this.__IM.onEntry((Object)this, "stringify$org_w3c_dom_Document", new Object[]{document});
            string = this.__M_stringify(document);
            this.__IM.onExit((Object)this, "stringify$org_w3c_dom_Document", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stringify$org_w3c_dom_Document", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_stringify(Document document) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public Document newDocument() {
        Document document;
        if (!this.__MnewDocument) {
            return this.__M_newDocument();
        }
        try {
            this.__IM.onEntry((Object)this, "newDocument", new Object[0]);
            document = this.__M_newDocument();
            this.__IM.onExit((Object)this, "newDocument", (Object)document);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "newDocument", throwable);
            throw throwable;
        }
        return document;
    }

    private Document __M_newDocument() {
        try {
            return this.__getfactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void bindModule(Module module) {
        if (!this.__MbindModule$com_fasterxml_jackson_databind_Module) {
            this.__M_bindModule(module);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindModule$com_fasterxml_jackson_databind_Module", new Object[]{module});
            this.__M_bindModule(module);
            this.__IM.onExit((Object)this, "bindModule$com_fasterxml_jackson_databind_Module", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindModule$com_fasterxml_jackson_databind_Module", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true)
    private void __M_bindModule(Module module) {
        this.register(module);
    }

    public synchronized void unbindModule(Module module) {
        if (!this.__MunbindModule$com_fasterxml_jackson_databind_Module) {
            this.__M_unbindModule(module);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindModule$com_fasterxml_jackson_databind_Module", new Object[]{module});
            this.__M_unbindModule(module);
            this.__IM.onExit((Object)this, "unbindModule$com_fasterxml_jackson_databind_Module", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindModule$com_fasterxml_jackson_databind_Module", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindModule(Module module) {
        this.unregister(module);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("factory")) {
                this.__Ffactory = true;
            }
            if (set.contains("lock")) {
                this.__Flock = true;
            }
            if (set.contains("mapper")) {
                this.__Fmapper = true;
            }
            if (set.contains("modules")) {
                this.__Fmodules = true;
            }
            if (set.contains("xml")) {
                this.__Fxml = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("mapper")) {
                this.__Mmapper = true;
            }
            if (set.contains("toJson$java_lang_Object")) {
                this.__MtoJson$java_lang_Object = true;
            }
            if (set.contains("toJsonP$java_lang_String$java_lang_Object")) {
                this.__MtoJsonP$java_lang_String$java_lang_Object = true;
            }
            if (set.contains("fromJson$com_fasterxml_jackson_databind_JsonNode$java_lang_Class")) {
                this.__MfromJson$com_fasterxml_jackson_databind_JsonNode$java_lang_Class = true;
            }
            if (set.contains("fromJson$java_lang_String$java_lang_Class")) {
                this.__MfromJson$java_lang_String$java_lang_Class = true;
            }
            if (set.contains("stringify$com_fasterxml_jackson_databind_JsonNode")) {
                this.__Mstringify$com_fasterxml_jackson_databind_JsonNode = true;
            }
            if (set.contains("parse$java_lang_String")) {
                this.__Mparse$java_lang_String = true;
            }
            if (set.contains("parse$java_io_InputStream")) {
                this.__Mparse$java_io_InputStream = true;
            }
            if (set.contains("newObject")) {
                this.__MnewObject = true;
            }
            if (set.contains("newArray")) {
                this.__MnewArray = true;
            }
            if (set.contains("validate")) {
                this.__Mvalidate = true;
            }
            if (set.contains("setMappers$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper")) {
                this.__MsetMappers$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper = true;
            }
            if (set.contains("applyMapperConfiguration$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper")) {
                this.__MapplyMapperConfiguration$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper = true;
            }
            if (set.contains("setFeature$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper$java_lang_String$java_lang_Boolean")) {
                this.__MsetFeature$com_fasterxml_jackson_databind_ObjectMapper$com_fasterxml_jackson_dataformat_xml_XmlMapper$java_lang_String$java_lang_Boolean = true;
            }
            if (set.contains("invalidate")) {
                this.__Minvalidate = true;
            }
            if (set.contains("register$com_fasterxml_jackson_databind_Module")) {
                this.__Mregister$com_fasterxml_jackson_databind_Module = true;
            }
            if (set.contains("rebuildMappers")) {
                this.__MrebuildMappers = true;
            }
            if (set.contains("unregister$com_fasterxml_jackson_databind_Module")) {
                this.__Munregister$com_fasterxml_jackson_databind_Module = true;
            }
            if (set.contains("xmlMapper")) {
                this.__MxmlMapper = true;
            }
            if (set.contains("fromString$java_lang_String")) {
                this.__MfromString$java_lang_String = true;
            }
            if (set.contains("fromInputStream$java_io_InputStream$java_nio_charset_Charset")) {
                this.__MfromInputStream$java_io_InputStream$java_nio_charset_Charset = true;
            }
            if (set.contains("fromXML$org_w3c_dom_Document$java_lang_Class")) {
                this.__MfromXML$org_w3c_dom_Document$java_lang_Class = true;
            }
            if (set.contains("fromXML$java_lang_String$java_lang_Class")) {
                this.__MfromXML$java_lang_String$java_lang_Class = true;
            }
            if (set.contains("stringify$org_w3c_dom_Document")) {
                this.__Mstringify$org_w3c_dom_Document = true;
            }
            if (set.contains("newDocument")) {
                this.__MnewDocument = true;
            }
            if (set.contains("bindModule$com_fasterxml_jackson_databind_Module")) {
                this.__MbindModule$com_fasterxml_jackson_databind_Module = true;
            }
            if (set.contains("unbindModule$com_fasterxml_jackson_databind_Module")) {
                this.__MunbindModule$com_fasterxml_jackson_databind_Module = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

