/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.configuration;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceController;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.chameleon.core.services.AbstractDeployer;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.services.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.configuration.ConfigurationImpl;
import org.wisdom.configuration.Mode;

@Component
@Provides
@Instantiate
public class ApplicationConfigurationImpl
extends ConfigurationImpl
implements ApplicationConfiguration,
Pojo {
    InstanceManager __IM;
    boolean __MConfigurationDeployer___accept$java_io_File;
    boolean __MConfigurationDeployer___onFileChange$java_io_File;
    public static final String APPLICATION_CONFIGURATION = "application.configuration";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationConfigurationImpl.class);
    private boolean __Fmode;
    private final Mode mode;
    private boolean __FbaseDirectory;
    private final File baseDirectory;
    private static final String APPMODE = "application.mode";
    private boolean __Fcontext;
    private final BundleContext context;
    private boolean __Fregistration;
    private ServiceRegistration<Deployer> registration;
    private boolean __FconfRegistrations;
    private Map<Configuration, ServiceRegistration<Configuration>> confRegistrations;
    private boolean __Fcontroller;
    @ServiceController(value=false)
    boolean controller;
    private boolean __Fwatcher;
    @Requires(optional=true, nullable=true)
    Watcher watcher;
    private boolean __FconfigFile;
    private final File configFile;
    private boolean __FappConf;
    private Config appConf;
    boolean __MmanageWatcher$org_osgi_framework_BundleContext;
    boolean __Mstart;
    boolean __MreloadConfiguration;
    boolean __Mstop;
    boolean __MloadConfiguration$java_lang_String;
    boolean __MgetBaseDir;
    boolean __MgetInteger$java_lang_String;
    boolean __MgetBoolean$java_lang_String;
    boolean __MgetLong$java_lang_String;
    boolean __MisDev;
    boolean __MisTest;
    boolean __MisProd;
    boolean __MgetFileWithDefault$java_lang_String$java_lang_String;
    boolean __MgetFileWithDefault$java_lang_String$java_io_File;
    boolean __MunregisterConfigurationsExposedAsServices;
    boolean __MregisterFirstLevelConfigurationAsServices;

    Mode __getmode() {
        if (!this.__Fmode) {
            return this.mode;
        }
        return (Mode)((Object)this.__IM.onGet((Object)this, "mode"));
    }

    void __setmode(Mode mode) {
        if (!this.__Fmode) {
            this.mode = mode;
            return;
        }
        this.__IM.onSet((Object)this, "mode", (Object)mode);
    }

    File __getbaseDirectory() {
        if (!this.__FbaseDirectory) {
            return this.baseDirectory;
        }
        return (File)this.__IM.onGet((Object)this, "baseDirectory");
    }

    void __setbaseDirectory(File file) {
        if (!this.__FbaseDirectory) {
            this.baseDirectory = file;
            return;
        }
        this.__IM.onSet((Object)this, "baseDirectory", (Object)file);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ServiceRegistration __getregistration() {
        if (!this.__Fregistration) {
            return this.registration;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "registration");
    }

    void __setregistration(ServiceRegistration serviceRegistration) {
        if (!this.__Fregistration) {
            this.registration = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "registration", (Object)serviceRegistration);
    }

    Map __getconfRegistrations() {
        if (!this.__FconfRegistrations) {
            return this.confRegistrations;
        }
        return (Map)this.__IM.onGet((Object)this, "confRegistrations");
    }

    void __setconfRegistrations(Map map) {
        if (!this.__FconfRegistrations) {
            this.confRegistrations = map;
            return;
        }
        this.__IM.onSet((Object)this, "confRegistrations", (Object)map);
    }

    boolean __getcontroller() {
        if (!this.__Fcontroller) {
            return this.controller;
        }
        Object object = this.__IM.onGet((Object)this, "controller");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setcontroller(boolean bl) {
        if (!this.__Fcontroller) {
            this.controller = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "controller", (Object)bl2);
    }

    Watcher __getwatcher() {
        if (!this.__Fwatcher) {
            return this.watcher;
        }
        return (Watcher)this.__IM.onGet((Object)this, "watcher");
    }

    void __setwatcher(Watcher watcher) {
        if (!this.__Fwatcher) {
            this.watcher = watcher;
            return;
        }
        this.__IM.onSet((Object)this, "watcher", (Object)watcher);
    }

    File __getconfigFile() {
        if (!this.__FconfigFile) {
            return this.configFile;
        }
        return (File)this.__IM.onGet((Object)this, "configFile");
    }

    void __setconfigFile(File file) {
        if (!this.__FconfigFile) {
            this.configFile = file;
            return;
        }
        this.__IM.onSet((Object)this, "configFile", (Object)file);
    }

    Config __getappConf() {
        if (!this.__FappConf) {
            return this.appConf;
        }
        return (Config)this.__IM.onGet((Object)this, "appConf");
    }

    void __setappConf(Config config) {
        if (!this.__FappConf) {
            this.appConf = config;
            return;
        }
        this.__IM.onSet((Object)this, "appConf", (Object)config);
    }

    public ApplicationConfigurationImpl(@Requires ParameterFactories converters, @Context BundleContext context) {
        this(null, converters, context);
    }

    private ApplicationConfigurationImpl(InstanceManager _manager, ParameterFactories converters, BundleContext context) {
        super(converters);
        this._setInstanceManager(_manager);
        this.__setconfRegistrations(new HashMap());
        String location = this.reloadConfiguration();
        this.__setcontext(context);
        String localMode = System.getProperty(APPMODE);
        if (localMode == null) {
            localMode = this.get(APPMODE);
        }
        if (localMode == null) {
            this.__setmode(Mode.DEV);
        } else {
            this.__setmode(Mode.valueOf(localMode));
        }
        this.__setconfigFile(new File(location));
        if (!this.__getconfigFile().isFile()) {
            LOGGER.error("Cannot load the application configuration (" + location + ") - the file does not exist, " + "Wisdom is using system properties only");
            this.__setbaseDirectory(new File(""));
        } else {
            this.__setbaseDirectory(this.__getconfigFile().getParentFile().getAbsoluteFile().getParentFile());
            LOGGER.info("Configuration file : {}", (Object)this.__getconfigFile().getAbsoluteFile());
            this.manageWatcher(context);
        }
        LOGGER.info("Base directory : {}", (Object)this.__getbaseDirectory().getAbsoluteFile());
        LOGGER.info("Wisdom running in " + this.__getmode().toString());
    }

    protected void manageWatcher(BundleContext context) {
        if (!this.__MmanageWatcher$org_osgi_framework_BundleContext) {
            this.__M_manageWatcher(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "manageWatcher$org_osgi_framework_BundleContext", new Object[]{context});
            this.__M_manageWatcher(context);
            this.__IM.onExit((Object)this, "manageWatcher$org_osgi_framework_BundleContext", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "manageWatcher$org_osgi_framework_BundleContext", throwable);
            throw throwable;
        }
    }

    private void __M_manageWatcher(BundleContext context) {
        if (context != null && (this.isDev() || this.getBooleanWithDefault("application.watch-configuration", false).booleanValue()) && this.__getwatcher() != null) {
            LOGGER.info("Enabling the watching of the configuration file");
            this.__getwatcher().add(this.__getconfigFile().getParentFile(), true);
            this.__setregistration(context.registerService(Deployer.class, (Object)new ConfigurationDeployer(), null));
        }
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__setcontroller(true);
        this.registerFirstLevelConfigurationAsServices();
    }

    private String reloadConfiguration() {
        String string;
        if (!this.__MreloadConfiguration) {
            return this.__M_reloadConfiguration();
        }
        try {
            this.__IM.onEntry((Object)this, "reloadConfiguration", new Object[0]);
            string = this.__M_reloadConfiguration();
            this.__IM.onExit((Object)this, "reloadConfiguration", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reloadConfiguration", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_reloadConfiguration() {
        Config configuration;
        String location = System.getProperty(APPLICATION_CONFIGURATION);
        if (location == null) {
            location = "conf/application.conf";
        }
        if ((configuration = this.loadConfiguration(location)) == null) {
            throw new IllegalStateException("Cannot load the application configuration (" + location + ") - Wisdom cannot " + "work properly without such configuration");
        }
        this.setConfiguration(configuration);
        return location;
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.unregisterConfigurationsExposedAsServices();
        if (this.__getregistration() != null) {
            this.__getregistration().unregister();
            this.__setregistration(null);
            try {
                this.__getwatcher().removeAndStopIfNeeded(this.__getconfigFile().getParentFile());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private Config loadConfiguration(String location) {
        Config config;
        if (!this.__MloadConfiguration$java_lang_String) {
            return this.__M_loadConfiguration(location);
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfiguration$java_lang_String", new Object[]{location});
            config = this.__M_loadConfiguration(location);
            this.__IM.onExit((Object)this, "loadConfiguration$java_lang_String", (Object)config);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfiguration$java_lang_String", throwable);
            throw throwable;
        }
        return config;
    }

    private Config __M_loadConfiguration(String location) {
        ConfigFactory.invalidateCaches();
        if (location != null) {
            File file = new File(location);
            this.__setappConf(ConfigFactory.parseFileAnySyntax(file, ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF)));
            Properties properties = new Properties();
            properties.put("application.baseDir", file.getParentFile().getAbsoluteFile().getParentFile().getAbsolutePath());
            return ConfigFactory.defaultOverrides().withFallback(this.__getappConf()).withFallback(ConfigFactory.parseProperties(properties)).resolve();
        }
        this.__setappConf(ConfigFactory.defaultOverrides());
        return ConfigFactory.defaultOverrides().resolve();
    }

    public File getBaseDir() {
        File file;
        if (!this.__MgetBaseDir) {
            return this.__M_getBaseDir();
        }
        try {
            this.__IM.onEntry((Object)this, "getBaseDir", new Object[0]);
            file = this.__M_getBaseDir();
            this.__IM.onExit((Object)this, "getBaseDir", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBaseDir", throwable);
            throw throwable;
        }
        return file;
    }

    private File __M_getBaseDir() {
        return this.__getbaseDirectory();
    }

    @Override
    public Integer getInteger(String key) {
        Integer n;
        if (!this.__MgetInteger$java_lang_String) {
            return this.__M_getInteger(key);
        }
        try {
            this.__IM.onEntry((Object)this, "getInteger$java_lang_String", new Object[]{key});
            n = this.__M_getInteger(key);
            this.__IM.onExit((Object)this, "getInteger$java_lang_String", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInteger$java_lang_String", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __M_getInteger(String key) {
        Integer r = super.getInteger(key);
        if (r == null) {
            LOGGER.error("No such key \"" + key + "\"");
            return null;
        }
        return r;
    }

    @Override
    public Boolean getBoolean(String key) {
        Boolean bl;
        if (!this.__MgetBoolean$java_lang_String) {
            return this.__M_getBoolean(key);
        }
        try {
            this.__IM.onEntry((Object)this, "getBoolean$java_lang_String", new Object[]{key});
            bl = this.__M_getBoolean(key);
            this.__IM.onExit((Object)this, "getBoolean$java_lang_String", (Object)bl);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBoolean$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private Boolean __M_getBoolean(String key) {
        Boolean r = super.getBoolean(key);
        if (r == null) {
            LOGGER.error("No such key \"" + key + "\"");
            return null;
        }
        return r;
    }

    @Override
    public Long getLong(String key) {
        Long l;
        if (!this.__MgetLong$java_lang_String) {
            return this.__M_getLong(key);
        }
        try {
            this.__IM.onEntry((Object)this, "getLong$java_lang_String", new Object[]{key});
            l = this.__M_getLong(key);
            this.__IM.onExit((Object)this, "getLong$java_lang_String", (Object)l);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLong$java_lang_String", throwable);
            throw throwable;
        }
        return l;
    }

    private Long __M_getLong(String key) {
        Long r = super.getLong(key);
        if (r == null) {
            LOGGER.error("No such key \"" + key + "\"");
            return null;
        }
        return r;
    }

    public boolean isDev() {
        boolean bl;
        if (!this.__MisDev) {
            return this.__M_isDev();
        }
        try {
            this.__IM.onEntry((Object)this, "isDev", new Object[0]);
            bl = this.__M_isDev();
            this.__IM.onExit((Object)this, "isDev", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isDev", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isDev() {
        return this.__getmode() == Mode.DEV;
    }

    public boolean isTest() {
        boolean bl;
        if (!this.__MisTest) {
            return this.__M_isTest();
        }
        try {
            this.__IM.onEntry((Object)this, "isTest", new Object[0]);
            bl = this.__M_isTest();
            this.__IM.onExit((Object)this, "isTest", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isTest", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isTest() {
        return this.__getmode() == Mode.TEST;
    }

    public boolean isProd() {
        boolean bl;
        if (!this.__MisProd) {
            return this.__M_isProd();
        }
        try {
            this.__IM.onEntry((Object)this, "isProd", new Object[0]);
            bl = this.__M_isProd();
            this.__IM.onExit((Object)this, "isProd", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isProd", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isProd() {
        return this.__getmode() == Mode.PROD;
    }

    public File getFileWithDefault(String key, String file) {
        File file2;
        if (!this.__MgetFileWithDefault$java_lang_String$java_lang_String) {
            return this.__M_getFileWithDefault(key, file);
        }
        try {
            this.__IM.onEntry((Object)this, "getFileWithDefault$java_lang_String$java_lang_String", new Object[]{key, file});
            file2 = this.__M_getFileWithDefault(key, file);
            this.__IM.onExit((Object)this, "getFileWithDefault$java_lang_String$java_lang_String", (Object)file2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFileWithDefault$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return file2;
    }

    private File __M_getFileWithDefault(String key, String file) {
        String value = this.get(key);
        if (value == null) {
            return new File(this.__getbaseDirectory(), file);
        }
        return new File(this.__getbaseDirectory(), value);
    }

    public File getFileWithDefault(String key, File file) {
        File file2;
        if (!this.__MgetFileWithDefault$java_lang_String$java_io_File) {
            return this.__M_getFileWithDefault(key, file);
        }
        try {
            this.__IM.onEntry((Object)this, "getFileWithDefault$java_lang_String$java_io_File", new Object[]{key, file});
            file2 = this.__M_getFileWithDefault(key, file);
            this.__IM.onExit((Object)this, "getFileWithDefault$java_lang_String$java_io_File", (Object)file2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFileWithDefault$java_lang_String$java_io_File", throwable);
            throw throwable;
        }
        return file2;
    }

    private File __M_getFileWithDefault(String key, File file) {
        String value = this.get(key);
        if (value == null) {
            return file;
        }
        return new File(this.__getbaseDirectory(), value);
    }

    protected void unregisterConfigurationsExposedAsServices() {
        if (!this.__MunregisterConfigurationsExposedAsServices) {
            this.__M_unregisterConfigurationsExposedAsServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterConfigurationsExposedAsServices", new Object[0]);
            this.__M_unregisterConfigurationsExposedAsServices();
            this.__IM.onExit((Object)this, "unregisterConfigurationsExposedAsServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterConfigurationsExposedAsServices", throwable);
            throw throwable;
        }
    }

    private void __M_unregisterConfigurationsExposedAsServices() {
        for (ServiceRegistration conf : this.__getconfRegistrations().values()) {
            conf.unregister();
        }
        this.__getconfRegistrations().clear();
    }

    private void registerFirstLevelConfigurationAsServices() {
        if (!this.__MregisterFirstLevelConfigurationAsServices) {
            this.__M_registerFirstLevelConfigurationAsServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerFirstLevelConfigurationAsServices", new Object[0]);
            this.__M_registerFirstLevelConfigurationAsServices();
            this.__IM.onExit((Object)this, "registerFirstLevelConfigurationAsServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerFirstLevelConfigurationAsServices", throwable);
            throw throwable;
        }
    }

    private void __M_registerFirstLevelConfigurationAsServices() {
        if (this.__getappConf() == null) {
            return;
        }
        for (Map.Entry entry : this.__getappConf().root().entrySet()) {
            if (((ConfigValue)entry.getValue()).valueType() != ConfigValueType.OBJECT) continue;
            Hashtable properties = new Hashtable();
            ((Dictionary)properties).put("configuration.name", entry.getKey());
            ((Dictionary)properties).put("configuration.path", entry.getKey());
            ConfigurationImpl cf = new ConfigurationImpl(this.converters, this.__getappConf().getConfig((String)entry.getKey()));
            ServiceRegistration reg = this.__getcontext().registerService(Configuration.class, (Object)cf, properties);
            this.__getconfRegistrations().put(cf, reg);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("appConf")) {
                this.__FappConf = true;
            }
            if (set.contains("baseDirectory")) {
                this.__FbaseDirectory = true;
            }
            if (set.contains("confRegistrations")) {
                this.__FconfRegistrations = true;
            }
            if (set.contains("configFile")) {
                this.__FconfigFile = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("controller")) {
                this.__Fcontroller = true;
            }
            if (set.contains("mode")) {
                this.__Fmode = true;
            }
            if (set.contains("registration")) {
                this.__Fregistration = true;
            }
            if (set.contains("watcher")) {
                this.__Fwatcher = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("ConfigurationDeployer___accept$java_io_File")) {
                this.__MConfigurationDeployer___accept$java_io_File = true;
            }
            if (set.contains("ConfigurationDeployer___onFileChange$java_io_File")) {
                this.__MConfigurationDeployer___onFileChange$java_io_File = true;
            }
            if (set.contains("manageWatcher$org_osgi_framework_BundleContext")) {
                this.__MmanageWatcher$org_osgi_framework_BundleContext = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("reloadConfiguration")) {
                this.__MreloadConfiguration = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("loadConfiguration$java_lang_String")) {
                this.__MloadConfiguration$java_lang_String = true;
            }
            if (set.contains("getBaseDir")) {
                this.__MgetBaseDir = true;
            }
            if (set.contains("getInteger$java_lang_String")) {
                this.__MgetInteger$java_lang_String = true;
            }
            if (set.contains("getBoolean$java_lang_String")) {
                this.__MgetBoolean$java_lang_String = true;
            }
            if (set.contains("getLong$java_lang_String")) {
                this.__MgetLong$java_lang_String = true;
            }
            if (set.contains("isDev")) {
                this.__MisDev = true;
            }
            if (set.contains("isTest")) {
                this.__MisTest = true;
            }
            if (set.contains("isProd")) {
                this.__MisProd = true;
            }
            if (set.contains("getFileWithDefault$java_lang_String$java_lang_String")) {
                this.__MgetFileWithDefault$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getFileWithDefault$java_lang_String$java_io_File")) {
                this.__MgetFileWithDefault$java_lang_String$java_io_File = true;
            }
            if (set.contains("unregisterConfigurationsExposedAsServices")) {
                this.__MunregisterConfigurationsExposedAsServices = true;
            }
            if (set.contains("registerFirstLevelConfigurationAsServices")) {
                this.__MregisterFirstLevelConfigurationAsServices = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public ApplicationConfigurationImpl(InstanceManager instanceManager) {
        this._setInstanceManager(instanceManager);
    }

    private class ConfigurationDeployer
    extends AbstractDeployer {
        private ConfigurationDeployer() {
        }

        public boolean accept(File file) {
            boolean bl;
            if (!ApplicationConfigurationImpl.this.__MConfigurationDeployer___accept$java_io_File) {
                return this.__M_accept(file);
            }
            try {
                ApplicationConfigurationImpl.this.__IM.onEntry((Object)this, "ConfigurationDeployer___accept$java_io_File", new Object[]{file});
                bl = this.__M_accept(file);
                ApplicationConfigurationImpl.this.__IM.onExit((Object)this, "ConfigurationDeployer___accept$java_io_File", (Object)new Boolean(bl));
            }
            catch (Throwable throwable) {
                ApplicationConfigurationImpl.this.__IM.onError((Object)this, "ConfigurationDeployer___accept$java_io_File", throwable);
                throw throwable;
            }
            return bl;
        }

        private boolean __M_accept(File file) {
            return file.getAbsoluteFile().equals(ApplicationConfigurationImpl.this.__getconfigFile().getAbsoluteFile());
        }

        public void onFileChange(File file) {
            if (!ApplicationConfigurationImpl.this.__MConfigurationDeployer___onFileChange$java_io_File) {
                this.__M_onFileChange(file);
                return;
            }
            try {
                ApplicationConfigurationImpl.this.__IM.onEntry((Object)this, "ConfigurationDeployer___onFileChange$java_io_File", new Object[]{file});
                this.__M_onFileChange(file);
                ApplicationConfigurationImpl.this.__IM.onExit((Object)this, "ConfigurationDeployer___onFileChange$java_io_File", null);
            }
            catch (Throwable throwable) {
                ApplicationConfigurationImpl.this.__IM.onError((Object)this, "ConfigurationDeployer___onFileChange$java_io_File", throwable);
                throw throwable;
            }
        }

        private void __M_onFileChange(File file) {
            ApplicationConfigurationImpl.this.unregisterConfigurationsExposedAsServices();
            ApplicationConfigurationImpl.this.__setcontroller(false);
            ApplicationConfigurationImpl.this.reloadConfiguration();
            ApplicationConfigurationImpl.this.__setcontroller(true);
            ApplicationConfigurationImpl.this.registerFirstLevelConfigurationAsServices();
        }
    }
}

