/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.configuration;

import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigResolveOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.api.content.ParameterFactories;

public class ConfigurationImpl
implements Configuration {
    private static final String ERROR_KEYNOTFOUND = "Key %s does not exist. Please include it in your application.conf. Otherwise this application will not work";
    protected static final String ERROR_NOSUCHKEY = "No such key \"";
    protected ParameterFactories converters;
    private Config configuration;

    public ConfigurationImpl(ParameterFactories converters, Config configuration) {
        this(converters);
        this.configuration = configuration;
    }

    protected ConfigurationImpl(ParameterFactories converters) {
        this.converters = converters;
    }

    protected void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }

    protected Config getConfiguration() {
        return this.configuration;
    }

    public String get(final String key) {
        return this.retrieve(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ConfigurationImpl.this.configuration.getString(key);
            }
        }, null);
    }

    public boolean has(String key) {
        return this.configuration.hasPath(key);
    }

    private <T> T retrieve(Callable<T> callable, T defaultValue) {
        try {
            T v = callable.call();
            return v != null ? v : defaultValue;
        }
        catch (ConfigException.Missing e) {
            return defaultValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getWithDefault(final String key, String defaultValue) {
        return this.retrieve(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ConfigurationImpl.this.configuration.getString(key);
            }
        }, defaultValue);
    }

    public Integer getInteger(final String key) {
        return this.retrieve(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ConfigurationImpl.this.configuration.getInt(key);
            }
        }, null);
    }

    public Integer getIntegerWithDefault(final String key, Integer defaultValue) {
        return this.retrieve(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ConfigurationImpl.this.configuration.getInt(key);
            }
        }, defaultValue);
    }

    public Double getDouble(final String key) {
        return this.retrieve(new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return ConfigurationImpl.this.configuration.getDouble(key);
            }
        }, null);
    }

    public Double getDoubleWithDefault(final String key, Double defaultValue) {
        return this.retrieve(new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return ConfigurationImpl.this.configuration.getDouble(key);
            }
        }, defaultValue);
    }

    public Boolean getBoolean(final String key) {
        return this.retrieve(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ConfigurationImpl.this.configuration.getBoolean(key);
            }
        }, null);
    }

    public Boolean getBooleanWithDefault(final String key, Boolean defaultValue) {
        return this.retrieve(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ConfigurationImpl.this.configuration.getBoolean(key);
            }
        }, defaultValue);
    }

    public Long getLong(final String key) {
        return this.retrieve(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return ConfigurationImpl.this.configuration.getLong(key);
            }
        }, null);
    }

    public Long getLongWithDefault(final String key, Long defaultValue) {
        return this.retrieve(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return ConfigurationImpl.this.configuration.getLong(key);
            }
        }, defaultValue);
    }

    public Long getLongOrDie(String key) {
        Long value = Long.getLong(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format(ERROR_KEYNOTFOUND, key));
        }
        return value;
    }

    public Boolean getBooleanOrDie(String key) {
        Boolean value = this.getBoolean(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format(ERROR_KEYNOTFOUND, key));
        }
        return value;
    }

    public Integer getIntegerOrDie(String key) {
        Integer value = this.getInteger(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format(ERROR_KEYNOTFOUND, key));
        }
        return value;
    }

    public Double getDoubleOrDie(String key) {
        Double value = this.getDouble(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format(ERROR_KEYNOTFOUND, key));
        }
        return value;
    }

    public String getOrDie(String key) {
        String value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format(ERROR_KEYNOTFOUND, key));
        }
        return value;
    }

    public Long getDuration(final String key, final TimeUnit unit) {
        return this.retrieve(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return ConfigurationImpl.this.configuration.getDuration(key, unit);
            }
        }, null);
    }

    public Long getDuration(final String key, final TimeUnit unit, long defaultValue) {
        return this.retrieve(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return ConfigurationImpl.this.configuration.getDuration(key, unit);
            }
        }, defaultValue);
    }

    public Long getBytes(final String key) {
        return this.retrieve(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return ConfigurationImpl.this.configuration.getBytes(key);
            }
        }, null);
    }

    public Long getBytes(final String key, long defaultValue) {
        return this.retrieve(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return ConfigurationImpl.this.configuration.getBytes(key);
            }
        }, defaultValue);
    }

    public String[] getStringArray(String key) {
        List<String> list = this.getList(key);
        return list.toArray(new String[list.size()]);
    }

    public List<String> getList(final String key) {
        return this.retrieve(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                try {
                    return ConfigurationImpl.this.configuration.getStringList(key);
                }
                catch (ConfigException.WrongType e) {
                    String s = ConfigurationImpl.this.get(key);
                    if (s != null) {
                        return ImmutableList.of((Object)s);
                    }
                    throw new IllegalArgumentException("Cannot create a list for the key '" + key + "'", e);
                }
            }
        }, Collections.emptyList());
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        properties.putAll(this.asMap());
        return properties;
    }

    public Map<String, Object> asMap() {
        return this.configuration.resolve(ConfigResolveOptions.defaults().setUseSystemEnvironment(true).setAllowUnresolved(true)).root().unwrapped();
    }

    public Configuration getConfiguration(String prefix) {
        try {
            Config value = this.configuration.getConfig(prefix);
            return new ConfigurationImpl(this.converters, value);
        }
        catch (ConfigException.Missing e) {
            return null;
        }
    }

    public <T> T get(String key, Class<T> clazz) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        return (T)this.converters.convertValue(value, clazz, clazz, null);
    }

    public <T> T getOrDie(String key, Class<T> clazz) {
        T val = this.get(key, clazz);
        if (val == null) {
            throw new IllegalArgumentException(String.format(ERROR_KEYNOTFOUND, key));
        }
        return val;
    }

    public <T> T get(String key, Class<T> clazz, T defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)this.converters.convertValue(value, clazz, clazz, null);
    }

    public <T> T get(String key, Class<T> clazz, String defaultValueAsString) {
        String value = this.get(key);
        return (T)this.converters.convertValue(value, clazz, clazz, defaultValueAsString);
    }
}

