/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.error;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.DefaultController;
import org.wisdom.api.bodies.NoHttpBody;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.content.Json;
import org.wisdom.api.exceptions.ExceptionMapper;
import org.wisdom.api.exceptions.HttpException;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.interception.Filter;
import org.wisdom.api.interception.RequestContext;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.Router;
import org.wisdom.api.templates.Template;
import org.wisdom.error.InterestingLines;
import org.wisdom.error.StackTraceUtils;

@Component
@Provides(specifications={Filter.class})
@Instantiate
public class DefaultPageErrorHandler
extends DefaultController
implements Filter,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wisdom-error");
    public static final Pattern ALL_REQUESTS = Pattern.compile("/.*");
    public static final String EMPTY_CONTENT = "";
    private boolean __Fnoroute;
    @Requires(filter="(name=error/404)", proxy=false, optional=true, id="404")
    private Template noroute;
    private boolean __Finternalerror;
    @Requires(filter="(name=error/500)", proxy=false, optional=true, id="500")
    private Template internalerror;
    private boolean __Fpipeline;
    @Requires(filter="(name=error/pipeline)", proxy=false, optional=true, id="pipeline")
    protected Template pipeline;
    private boolean __Frouter;
    @Requires
    protected Router router;
    private boolean __Fconfiguration;
    @Requires
    protected ApplicationConfiguration configuration;
    private boolean __Fjson;
    @Requires
    protected Json json;
    private boolean __Fmappers;
    @Requires(optional=true)
    protected ExceptionMapper[] mappers;
    private boolean __FpipelineErrorDirectory;
    private File pipelineErrorDirectory;
    boolean __Mstart;
    boolean __MgetFirstErrorFile;
    boolean __MrenderInternalError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable;
    boolean __Mcall$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext;
    boolean __MrenderPipelineError$java_io_File;
    boolean __MrenderNotFound$org_wisdom_api_router_Route$org_wisdom_api_http_Result;
    boolean __MswitchToGet$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext;
    boolean __Muri;
    boolean __Mpriority;

    Template __getnoroute() {
        if (!this.__Fnoroute) {
            return this.noroute;
        }
        return (Template)this.__IM.onGet((Object)this, "noroute");
    }

    void __setnoroute(Template template) {
        if (!this.__Fnoroute) {
            this.noroute = template;
            return;
        }
        this.__IM.onSet((Object)this, "noroute", (Object)template);
    }

    Template __getinternalerror() {
        if (!this.__Finternalerror) {
            return this.internalerror;
        }
        return (Template)this.__IM.onGet((Object)this, "internalerror");
    }

    void __setinternalerror(Template template) {
        if (!this.__Finternalerror) {
            this.internalerror = template;
            return;
        }
        this.__IM.onSet((Object)this, "internalerror", (Object)template);
    }

    Template __getpipeline() {
        if (!this.__Fpipeline) {
            return this.pipeline;
        }
        return (Template)this.__IM.onGet((Object)this, "pipeline");
    }

    void __setpipeline(Template template) {
        if (!this.__Fpipeline) {
            this.pipeline = template;
            return;
        }
        this.__IM.onSet((Object)this, "pipeline", (Object)template);
    }

    Router __getrouter() {
        if (!this.__Frouter) {
            return this.router;
        }
        return (Router)this.__IM.onGet((Object)this, "router");
    }

    void __setrouter(Router router) {
        if (!this.__Frouter) {
            this.router = router;
            return;
        }
        this.__IM.onSet((Object)this, "router", (Object)router);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Json __getjson() {
        if (!this.__Fjson) {
            return this.json;
        }
        return (Json)this.__IM.onGet((Object)this, "json");
    }

    void __setjson(Json json) {
        if (!this.__Fjson) {
            this.json = json;
            return;
        }
        this.__IM.onSet((Object)this, "json", (Object)json);
    }

    ExceptionMapper[] __getmappers() {
        if (!this.__Fmappers) {
            return this.mappers;
        }
        return (ExceptionMapper[])this.__IM.onGet((Object)this, "mappers");
    }

    void __setmappers(ExceptionMapper[] exceptionMapperArray) {
        if (!this.__Fmappers) {
            this.mappers = exceptionMapperArray;
            return;
        }
        this.__IM.onSet((Object)this, "mappers", (Object)exceptionMapperArray);
    }

    File __getpipelineErrorDirectory() {
        if (!this.__FpipelineErrorDirectory) {
            return this.pipelineErrorDirectory;
        }
        return (File)this.__IM.onGet((Object)this, "pipelineErrorDirectory");
    }

    void __setpipelineErrorDirectory(File file) {
        if (!this.__FpipelineErrorDirectory) {
            this.pipelineErrorDirectory = file;
            return;
        }
        this.__IM.onSet((Object)this, "pipelineErrorDirectory", (Object)file);
    }

    public DefaultPageErrorHandler() {
        this(null);
    }

    private DefaultPageErrorHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__setpipelineErrorDirectory(new File(this.__getconfiguration().getBaseDir().getParentFile(), "pipeline"));
    }

    public File getFirstErrorFile() {
        File file;
        if (!this.__MgetFirstErrorFile) {
            return this.__M_getFirstErrorFile();
        }
        try {
            this.__IM.onEntry((Object)this, "getFirstErrorFile", new Object[0]);
            file = this.__M_getFirstErrorFile();
            this.__IM.onExit((Object)this, "getFirstErrorFile", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFirstErrorFile", throwable);
            throw throwable;
        }
        return file;
    }

    private File __M_getFirstErrorFile() {
        if (!this.__getpipelineErrorDirectory().isDirectory()) {
            return null;
        }
        File[] files = this.__getpipelineErrorDirectory().listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    private Result renderInternalError(Context context, Route route, Throwable e) {
        Result result;
        if (!this.__MrenderInternalError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable) {
            return this.__M_renderInternalError(context, route, e);
        }
        try {
            this.__IM.onEntry((Object)this, "renderInternalError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable", new Object[]{context, route, e});
            result = this.__M_renderInternalError(context, route, e);
            this.__IM.onExit((Object)this, "renderInternalError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "renderInternalError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_renderInternalError(Context context, Route route, Throwable e) {
        StackTraceElement[] stack;
        String cause;
        if (this.__getinternalerror() == null) {
            return DefaultPageErrorHandler.internalServerError((Throwable)e);
        }
        Throwable localException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
        if (localException.getCause() != null) {
            cause = localException.getCause().getMessage();
            stack = localException.getCause().getStackTrace();
        } else {
            cause = localException.getMessage();
            stack = localException.getStackTrace();
        }
        String fileName = null;
        int line = -1;
        if (stack != null && stack.length != 0) {
            fileName = stack[0].getFileName();
            line = stack[0].getLineNumber();
        }
        List<StackTraceElement> cleaned = StackTraceUtils.cleanup(stack);
        return DefaultPageErrorHandler.internalServerError((Renderable)this.render(this.__getinternalerror(), new Object[]{"route", route, "context", context, "exception", localException, "message", localException.getMessage(), "cause", cause, "file", fileName, "line", line, "stack", cleaned}));
    }

    public Result call(Route route, RequestContext context) throws Exception {
        Result result;
        if (!this.__Mcall$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext) {
            return this.__M_call(route, context);
        }
        try {
            this.__IM.onEntry((Object)this, "call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", new Object[]{route, context});
            result = this.__M_call(route, context);
            this.__IM.onExit((Object)this, "call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_call(Route route, RequestContext context) throws Exception {
        File error;
        if (this.__getconfiguration().isDev() && context.request().accepts("text/html") && this.__getpipeline() != null && (error = this.getFirstErrorFile()) != null) {
            this.logger().debug("Error file detected, preparing rendering");
            try {
                return this.renderPipelineError(error);
            }
            catch (IOException e) {
                LOGGER.error("An exception occurred while generating the error page for {} {}", new Object[]{route.getHttpMethod(), route.getUrl(), e});
                return this.renderInternalError(context.context(), route, e);
            }
        }
        try {
            Result result = context.proceed();
            if (result.getStatusCode() == 404 && result.getRenderable() instanceof NoHttpBody) {
                if (route.getHttpMethod() == HttpMethod.HEAD) {
                    return this.switchToGet(route, context);
                }
                return this.renderNotFound(route, result);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            LOGGER.error("An exception occurred while processing request {} {}", new Object[]{route.getHttpMethod(), route.getUrl(), cause});
            if (cause instanceof HttpException) {
                LOGGER.error("A HTTP exception occurred while processing request {} {}", new Object[]{route.getHttpMethod(), route.getUrl(), e});
                return ((HttpException)cause).toResult();
            }
            for (ExceptionMapper mapper : this.__getmappers()) {
                if (!mapper.getExceptionClass().equals(cause.getClass())) continue;
                return mapper.toResult((Exception)cause);
            }
            return this.renderInternalError(context.context(), route, e);
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while processing request {} {}", new Object[]{route.getHttpMethod(), route.getUrl(), e});
            Throwable cause = e.getCause();
            for (ExceptionMapper mapper : this.__getmappers()) {
                if (!mapper.getExceptionClass().equals(cause.getClass())) continue;
                return mapper.toResult((Exception)cause);
            }
            return this.renderInternalError(context.context(), route, e);
        }
    }

    private Result renderPipelineError(File error) throws IOException {
        Result result;
        if (!this.__MrenderPipelineError$java_io_File) {
            return this.__M_renderPipelineError(error);
        }
        try {
            this.__IM.onEntry((Object)this, "renderPipelineError$java_io_File", new Object[]{error});
            result = this.__M_renderPipelineError(error);
            this.__IM.onExit((Object)this, "renderPipelineError$java_io_File", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "renderPipelineError$java_io_File", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_renderPipelineError(File error) throws IOException {
        String content = FileUtils.readFileToString((File)error);
        ObjectNode node = (ObjectNode)this.__getjson().parse(content);
        String message = node.get("message").asText();
        String file = null;
        if (node.get("file") != null) {
            file = node.get("file").asText();
        }
        String watcher = node.get("watcher").asText();
        int line = -1;
        int character = -1;
        if (node.get("line") != null) {
            line = node.get("line").asInt();
        }
        String title = null;
        if (node.get("title") != null) {
            title = node.get("title").asText();
        }
        if (node.get("character") != null) {
            character = node.get("character").asInt();
        }
        String fileContent = EMPTY_CONTENT;
        InterestingLines lines = null;
        File source = null;
        if (file != null && (source = new File(file)).isFile()) {
            fileContent = FileUtils.readFileToString((File)source);
            if (line != -1 && line != 0) {
                lines = InterestingLines.extractInterestedLines(fileContent, line, 4, this.logger());
            }
        }
        return DefaultPageErrorHandler.internalServerError((Renderable)this.render(this.__getpipeline(), new Object[]{"title", title, "message", message, "source", source, "line", line, "character", character, "lines", lines, "watcher", watcher}));
    }

    private Result renderNotFound(Route route, Result result) {
        Result result2;
        if (!this.__MrenderNotFound$org_wisdom_api_router_Route$org_wisdom_api_http_Result) {
            return this.__M_renderNotFound(route, result);
        }
        try {
            this.__IM.onEntry((Object)this, "renderNotFound$org_wisdom_api_router_Route$org_wisdom_api_http_Result", new Object[]{route, result});
            result2 = this.__M_renderNotFound(route, result);
            this.__IM.onExit((Object)this, "renderNotFound$org_wisdom_api_router_Route$org_wisdom_api_http_Result", (Object)result2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "renderNotFound$org_wisdom_api_router_Route$org_wisdom_api_http_Result", throwable);
            throw throwable;
        }
        return result2;
    }

    private Result __M_renderNotFound(Route route, Result result) {
        if (this.__getnoroute() == null) {
            return result;
        }
        return Results.notFound((Renderable)this.render(this.__getnoroute(), new Object[]{"method", route.getHttpMethod(), "uri", route.getUrl(), "routes", this.__getrouter().getRoutes()}));
    }

    private Result switchToGet(Route route, RequestContext context) {
        Result result;
        if (!this.__MswitchToGet$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext) {
            return this.__M_switchToGet(route, context);
        }
        try {
            this.__IM.onEntry((Object)this, "switchToGet$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", new Object[]{route, context});
            result = this.__M_switchToGet(route, context);
            this.__IM.onExit((Object)this, "switchToGet$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "switchToGet$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_switchToGet(Route route, RequestContext context) {
        Route getRoute = this.__getrouter().getRouteFor(HttpMethod.GET, route.getUrl());
        if (getRoute == null || getRoute.isUnbound()) {
            return this.renderNotFound(route, Results.notFound());
        }
        try {
            Result result = getRoute.invoke();
            Renderable renderable = result.getRenderable();
            String type = (String)result.getHeaders().get("Content-Type");
            String length = (String)result.getHeaders().get("Content-Length");
            Result newResult = result.render(EMPTY_CONTENT);
            if (type != null) {
                newResult.with("Content-Type", type);
            } else if (renderable != null) {
                newResult.with("Content-Type", renderable.mimetype());
            }
            if (length != null) {
                newResult.with("Content-Length", length);
            } else if (renderable != null) {
                this.logger().info("Length from renderable : " + renderable.length());
                newResult.with("Content-Length", String.valueOf(renderable.length()));
            }
            return newResult;
        }
        catch (Exception exception) {
            LOGGER.error("An exception occurred while processing request {} {}", new Object[]{route.getHttpMethod(), route.getUrl(), exception});
            return this.renderInternalError(context.context(), route, exception);
        }
    }

    public Pattern uri() {
        Pattern pattern;
        if (!this.__Muri) {
            return this.__M_uri();
        }
        try {
            this.__IM.onEntry((Object)this, "uri", new Object[0]);
            pattern = this.__M_uri();
            this.__IM.onExit((Object)this, "uri", (Object)pattern);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uri", throwable);
            throw throwable;
        }
        return pattern;
    }

    private Pattern __M_uri() {
        return ALL_REQUESTS;
    }

    public int priority() {
        int n;
        if (!this.__Mpriority) {
            return this.__M_priority();
        }
        try {
            this.__IM.onEntry((Object)this, "priority", new Object[0]);
            n = this.__M_priority();
            this.__IM.onExit((Object)this, "priority", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "priority", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_priority() {
        return 1000;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("internalerror")) {
                this.__Finternalerror = true;
            }
            if (set.contains("json")) {
                this.__Fjson = true;
            }
            if (set.contains("mappers")) {
                this.__Fmappers = true;
            }
            if (set.contains("noroute")) {
                this.__Fnoroute = true;
            }
            if (set.contains("pipeline")) {
                this.__Fpipeline = true;
            }
            if (set.contains("pipelineErrorDirectory")) {
                this.__FpipelineErrorDirectory = true;
            }
            if (set.contains("router")) {
                this.__Frouter = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("getFirstErrorFile")) {
                this.__MgetFirstErrorFile = true;
            }
            if (set.contains("renderInternalError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable")) {
                this.__MrenderInternalError$org_wisdom_api_http_Context$org_wisdom_api_router_Route$java_lang_Throwable = true;
            }
            if (set.contains("call$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext = true;
            }
            if (set.contains("renderPipelineError$java_io_File")) {
                this.__MrenderPipelineError$java_io_File = true;
            }
            if (set.contains("renderNotFound$org_wisdom_api_router_Route$org_wisdom_api_http_Result")) {
                this.__MrenderNotFound$org_wisdom_api_router_Route$org_wisdom_api_http_Result = true;
            }
            if (set.contains("switchToGet$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext")) {
                this.__MswitchToGet$org_wisdom_api_router_Route$org_wisdom_api_interception_RequestContext = true;
            }
            if (set.contains("uri")) {
                this.__Muri = true;
            }
            if (set.contains("priority")) {
                this.__Mpriority = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

