/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.error;

import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;

public class InterestingLines {
    public final int firstLine;
    public final int errorLine;
    public final String[] focus;

    InterestingLines(int firstLine, String[] focus, int errorLine) {
        this.firstLine = firstLine;
        this.errorLine = errorLine;
        this.focus = focus;
    }

    public static InterestingLines extractInterestedLines(String source, int line, int border, Logger logger) {
        try {
            if (source == null) {
                return null;
            }
            String[] lines = source.split("\n");
            int firstLine = Math.max(0, line - border);
            int lastLine = Math.min(lines.length - 1, line + border);
            ArrayList<String> focusOn = new ArrayList<String>();
            focusOn.addAll(Arrays.asList(lines).subList(firstLine, lastLine + 1));
            return new InterestingLines(firstLine + 1, focusOn.toArray(new String[focusOn.size()]), line - firstLine - 1);
        }
        catch (Exception e) {
            logger.error("Cannot extract the interesting lines", (Throwable)e);
            return null;
        }
    }
}

