/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.resources;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Result;
import org.wisdom.resources.CacheUtils;
import org.wisdom.resources.WebJarLib;

class BundleWebJarLib
extends WebJarLib {
    public final Bundle bundle;
    public static final Logger LOGGER = LoggerFactory.getLogger(BundleWebJarLib.class);
    private Map<String, URL> index = new TreeMap<String, URL>();

    BundleWebJarLib(String name, String version, Bundle bundle) {
        super(name, version);
        this.bundle = bundle;
        this.index();
    }

    @Override
    public Collection<String> names() {
        return this.index.keySet();
    }

    @Override
    public Result get(String path, Context context, ApplicationConfiguration configuration, Crypto crypto) {
        URL url = this.index.get(path);
        return CacheUtils.fromBundle(this.bundle, url, context, configuration, crypto);
    }

    @Override
    public Object get(String path) {
        return this.index.get(path);
    }

    @Override
    public long lastModified() {
        return this.bundle.getLastModified();
    }

    public Collection<String> resources() {
        return this.index.keySet();
    }

    private void index() {
        LOGGER.debug("Indexing files for WebJar library {}-{} contained in bundle {} [{}]", new Object[]{this.name, this.version, this.bundle.getSymbolicName(), this.bundle.getBundleId()});
        Enumeration urls = this.bundle.findEntries("META-INF/resources/webjars/" + this.name + "/" + this.version, "*", true);
        String root = "/META-INF/resources/webjars/" + this.name + "/" + this.version;
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            if (!url.getPath().startsWith(root) || url.getPath().length() <= root.length()) continue;
            String path = url.getPath().substring(root.length() + 1);
            this.index.put(path, url);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.bundle.getBundleId() + "]";
    }
}

