/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.resources;

import java.io.File;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.slf4j.LoggerFactory;
import org.wisdom.api.asset.Asset;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.utils.DateUtil;

public class CacheUtils {
    public static final String HTTP_CACHE_CONTROL_MAX_AGE = "http.cache_control_max_age";
    public static final String HTTP_CACHE_CONTROL_DEFAULT = "3600";
    public static final String HTTP_USE_ETAG = "http.useETag";
    public static final boolean HTTP_USE_ETAG_DEFAULT = true;

    public static void addLastModified(Result result, long lastModified) {
        result.with("Last-Modified", DateUtil.formatForHttpHeader((Long)lastModified));
    }

    public static boolean isNotModified(Context context, long lastModified, String etag) {
        String browserEtag = context.header("If-None-Match");
        if (browserEtag != null) {
            return browserEtag.equals(etag);
        }
        String ifModifiedSince = context.header("If-Modified-Since");
        if (ifModifiedSince != null && lastModified > 0L && !ifModifiedSince.isEmpty()) {
            try {
                return ifModifiedSince.equals(DateUtil.formatForHttpHeader((Long)lastModified));
            }
            catch (IllegalArgumentException ex) {
                LoggerFactory.getLogger(CacheUtils.class).error("Cannot build the date string for {}", (Object)lastModified, (Object)ex);
                return true;
            }
        }
        return false;
    }

    public static String computeEtag(long lastModification, ApplicationConfiguration configuration, Crypto crypto) {
        boolean useEtag = configuration.getBooleanWithDefault(HTTP_USE_ETAG, Boolean.valueOf(true));
        if (!useEtag) {
            return null;
        }
        String raw = Long.toString(lastModification);
        return crypto.hexSHA1(raw);
    }

    public static void addCacheControlAndEtagToResult(Result result, String etag, ApplicationConfiguration configuration) {
        String maxAge = configuration.getWithDefault(HTTP_CACHE_CONTROL_MAX_AGE, HTTP_CACHE_CONTROL_DEFAULT);
        if ("0".equals(maxAge)) {
            result.with("Cache-Control", "no-cache");
        } else {
            result.with("Cache-Control", "max-age=" + maxAge);
        }
        boolean useEtag = configuration.getBooleanWithDefault(HTTP_USE_ETAG, Boolean.valueOf(true));
        if (useEtag) {
            result.with("Etag", etag);
        }
    }

    public static Result fromFile(File file, Context context, ApplicationConfiguration configuration, Crypto crypto) {
        String etag;
        long lastModified = file.lastModified();
        if (CacheUtils.isNotModified(context, lastModified, etag = CacheUtils.computeEtag(lastModified, configuration, crypto))) {
            return new Result(304);
        }
        Result result = Results.ok((File)file);
        CacheUtils.addLastModified(result, lastModified);
        CacheUtils.addCacheControlAndEtagToResult(result, etag, configuration);
        return result;
    }

    public static Result fromBundle(Bundle bundle, URL url, Context context, ApplicationConfiguration configuration, Crypto crypto) {
        String etag;
        long lastModified = bundle.getLastModified();
        if (CacheUtils.isNotModified(context, lastModified, etag = CacheUtils.computeEtag(lastModified, configuration, crypto))) {
            return new Result(304);
        }
        Result result = Results.ok((URL)url);
        CacheUtils.addLastModified(result, lastModified);
        CacheUtils.addCacheControlAndEtagToResult(result, etag, configuration);
        return result;
    }

    public static Result fromAsset(Context context, Asset asset, ApplicationConfiguration configuration) {
        if (CacheUtils.isNotModified(context, asset.getLastModified(), asset.getEtag())) {
            return new Result(304);
        }
        Result result = asset.getContent() instanceof File ? Results.ok((File)((File)asset.getContent())) : (asset.getContent() instanceof URL ? Results.ok((URL)((URL)asset.getContent())) : Results.ok((Object)asset.getContent()));
        CacheUtils.addLastModified(result, asset.getLastModified());
        CacheUtils.addCacheControlAndEtagToResult(result, asset.getEtag(), configuration);
        return result;
    }
}

