/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.resources;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.wisdom.api.Controller;
import org.wisdom.api.DefaultController;
import org.wisdom.api.asset.Asset;
import org.wisdom.api.asset.AssetProvider;
import org.wisdom.api.asset.DefaultAsset;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.RouteBuilder;
import org.wisdom.resources.BundleWebJarLib;
import org.wisdom.resources.CacheUtils;
import org.wisdom.resources.FileWebJarLib;
import org.wisdom.resources.WebJarDeployer;
import org.wisdom.resources.WebJarLib;

@Component(immediate=true)
@Provides(specifications={Controller.class, AssetProvider.class})
@Instantiate(name="WebJarResourceController")
public class WebJarController
extends DefaultController
implements BundleTrackerCustomizer<List<BundleWebJarLib>>,
AssetProvider {
    InstanceManager __IM;
    boolean __M1___compare$org_wisdom_resources_WebJarLib$org_wisdom_resources_WebJarLib;
    boolean __M1___compare$java_lang_Object$java_lang_Object;
    boolean __M2___accept$java_io_File;
    public static final Pattern WEBJAR_ROOT_REGEX = Pattern.compile(".*META-INF/resources/webjars/([^/]+)/([^/]+)/");
    public static final String WEBJAR_LOCATION = "META-INF/resources/webjars/";
    public static final Pattern WEBJAR_REGEX = Pattern.compile(".*META-INF/resources/webjars/([^/]+)/([^/]+)/.*");
    static Pattern PATTERN = Pattern.compile("([^/]+)(/([^/]+))?/(.*)");
    private boolean __Fdeployer;
    private final WebJarDeployer deployer;
    private boolean __Fdirectory;
    private final File directory;
    private boolean __Ftracker;
    private final BundleTracker<List<BundleWebJarLib>> tracker;
    private boolean __Flibraries;
    Set<WebJarLib> libraries;
    private boolean __Fcrypto;
    @Requires
    Crypto crypto;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MbuildFileIndex;
    boolean __MindexSize;
    boolean __Mlibs;
    boolean __MfindLibsContaining$java_lang_String;
    boolean __Mfind$java_lang_String;
    boolean __Mroutes;
    boolean __Mserve;
    boolean __Mfind$java_lang_String$java_lang_String;
    boolean __MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent;
    boolean __MaddWebJarLibs$java_util_Collection;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List;
    boolean __MremoveWebJarLibs$java_util_Collection;
    boolean __Massets;
    boolean __MassetAt$java_lang_String;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;

    WebJarDeployer __getdeployer() {
        if (!this.__Fdeployer) {
            return this.deployer;
        }
        return (WebJarDeployer)((Object)this.__IM.onGet((Object)this, "deployer"));
    }

    void __setdeployer(WebJarDeployer webJarDeployer) {
        if (!this.__Fdeployer) {
            this.deployer = webJarDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "deployer", (Object)webJarDeployer);
    }

    File __getdirectory() {
        if (!this.__Fdirectory) {
            return this.directory;
        }
        return (File)this.__IM.onGet((Object)this, "directory");
    }

    void __setdirectory(File file) {
        if (!this.__Fdirectory) {
            this.directory = file;
            return;
        }
        this.__IM.onSet((Object)this, "directory", (Object)file);
    }

    BundleTracker __gettracker() {
        if (!this.__Ftracker) {
            return this.tracker;
        }
        return (BundleTracker)this.__IM.onGet((Object)this, "tracker");
    }

    void __settracker(BundleTracker bundleTracker) {
        if (!this.__Ftracker) {
            this.tracker = bundleTracker;
            return;
        }
        this.__IM.onSet((Object)this, "tracker", (Object)bundleTracker);
    }

    Set __getlibraries() {
        if (!this.__Flibraries) {
            return this.libraries;
        }
        return (Set)this.__IM.onGet((Object)this, "libraries");
    }

    void __setlibraries(Set set) {
        if (!this.__Flibraries) {
            this.libraries = set;
            return;
        }
        this.__IM.onSet((Object)this, "libraries", (Object)set);
    }

    Crypto __getcrypto() {
        if (!this.__Fcrypto) {
            return this.crypto;
        }
        return (Crypto)this.__IM.onGet((Object)this, "crypto");
    }

    void __setcrypto(Crypto crypto) {
        if (!this.__Fcrypto) {
            this.crypto = crypto;
            return;
        }
        this.__IM.onSet((Object)this, "crypto", (Object)crypto);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    WebJarController(Crypto crypto, ApplicationConfiguration configuration, String path) {
        this(null, crypto, configuration, path);
    }

    private WebJarController(InstanceManager _manager, Crypto crypto, ApplicationConfiguration configuration, String path) {
        this._setInstanceManager(_manager);
        this.__setlibraries(new TreeSet<WebJarLib>(new Comparator<WebJarLib>(){

            @Override
            public int compare(WebJarLib webJarLib, WebJarLib webJarLib2) {
                int n;
                if (!WebJarController.this.__M1___compare$org_wisdom_resources_WebJarLib$org_wisdom_resources_WebJarLib) {
                    return this.__M_compare(webJarLib, webJarLib2);
                }
                try {
                    WebJarController.this.__IM.onEntry((Object)this, "1___compare$org_wisdom_resources_WebJarLib$org_wisdom_resources_WebJarLib", new Object[]{webJarLib, webJarLib2});
                    n = this.__M_compare(webJarLib, webJarLib2);
                    WebJarController.this.__IM.onExit((Object)this, "1___compare$org_wisdom_resources_WebJarLib$org_wisdom_resources_WebJarLib", (Object)new Integer(n));
                }
                catch (Throwable throwable) {
                    WebJarController.this.__IM.onError((Object)this, "1___compare$org_wisdom_resources_WebJarLib$org_wisdom_resources_WebJarLib", throwable);
                    throw throwable;
                }
                return n;
            }

            private int __M_compare(WebJarLib o1, WebJarLib o2) {
                if (o1 instanceof FileWebJarLib && o2 instanceof BundleWebJarLib) {
                    return -1;
                }
                if (o1 instanceof BundleWebJarLib && o2 instanceof FileWebJarLib) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }

            private int __M_compare(Object object, Object object2) {
                return this.compare((WebJarLib)object, (WebJarLib)object2);
            }
        }));
        this.__setcrypto(crypto);
        this.__setconfiguration(configuration);
        this.__setdirectory(new File(configuration.getBaseDir(), path));
        this.__settracker(null);
        this.__setdeployer(null);
        this.start();
    }

    public WebJarController(@Context BundleContext context, @Property(value="assets/libs", name="path") String path) {
        this(null, context, path);
    }

    private WebJarController(InstanceManager _manager, BundleContext context, String path) {
        this._setInstanceManager(_manager);
        this.__setlibraries(new TreeSet<WebJarLib>(new /* invalid duplicate definition of identical inner class */));
        this.__setdirectory(new File(this.__getconfiguration().getBaseDir(), path));
        this.__settracker(new BundleTracker(context, 32, (BundleTrackerCustomizer)this));
        this.__setdeployer(new WebJarDeployer(context, this));
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        if (this.__getdirectory().isDirectory()) {
            this.buildFileIndex();
        }
        if (this.__gettracker() != null) {
            this.__gettracker().open();
        }
        if (this.__getdeployer() != null) {
            this.__getdeployer().start();
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        if (this.__getdeployer() != null) {
            this.__getdeployer().stop();
        }
        if (this.__gettracker() != null) {
            this.__gettracker().close();
        }
        this.__getlibraries().clear();
    }

    private void buildFileIndex() {
        if (!this.__MbuildFileIndex) {
            this.__M_buildFileIndex();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "buildFileIndex", new Object[0]);
            this.__M_buildFileIndex();
            this.__IM.onExit((Object)this, "buildFileIndex", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "buildFileIndex", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_buildFileIndex() {
        if (this.__getdirectory().listFiles() == null) {
            return;
        }
        FileFilter isDirectory = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean bl;
                if (!WebJarController.this.__M2___accept$java_io_File) {
                    return this.__M_accept(file);
                }
                try {
                    WebJarController.this.__IM.onEntry((Object)this, "2___accept$java_io_File", new Object[]{file});
                    bl = this.__M_accept(file);
                    WebJarController.this.__IM.onExit((Object)this, "2___accept$java_io_File", (Object)new Boolean(bl));
                }
                catch (Throwable throwable) {
                    WebJarController.this.__IM.onError((Object)this, "2___accept$java_io_File", throwable);
                    throw throwable;
                }
                return bl;
            }

            private boolean __M_accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        File[] names = this.__getdirectory().listFiles(isDirectory);
        if (names == null) {
            return;
        }
        WebJarController webJarController = this;
        synchronized (webJarController) {
            for (File dir : names) {
                String library = dir.getName();
                File[] versions = dir.listFiles(isDirectory);
                if (versions == null) continue;
                for (File ver : versions) {
                    String version = ver.getName();
                    FileWebJarLib lib = new FileWebJarLib(library, version, ver);
                    this.logger().info("Exploded web jar libraries detected : {}", (Object)lib);
                    this.__getlibraries().add(lib);
                }
            }
        }
    }

    int indexSize() {
        int n;
        if (!this.__MindexSize) {
            return this.__M_indexSize();
        }
        try {
            this.__IM.onEntry((Object)this, "indexSize", new Object[0]);
            n = this.__M_indexSize();
            this.__IM.onExit((Object)this, "indexSize", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "indexSize", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_indexSize() {
        int count = 0;
        for (WebJarLib lib : this.libs()) {
            count += lib.names().size();
        }
        return count;
    }

    synchronized List<WebJarLib> libs() {
        List<WebJarLib> list;
        if (!this.__Mlibs) {
            return this.__M_libs();
        }
        try {
            this.__IM.onEntry((Object)this, "libs", new Object[0]);
            list = this.__M_libs();
            this.__IM.onExit((Object)this, "libs", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "libs", throwable);
            throw throwable;
        }
        return list;
    }

    private List<WebJarLib> __M_libs() {
        return new ArrayList<WebJarLib>(this.__getlibraries());
    }

    private List<WebJarLib> findLibsContaining(String path) {
        List<WebJarLib> list;
        if (!this.__MfindLibsContaining$java_lang_String) {
            return this.__M_findLibsContaining(path);
        }
        try {
            this.__IM.onEntry((Object)this, "findLibsContaining$java_lang_String", new Object[]{path});
            list = this.__M_findLibsContaining(path);
            this.__IM.onExit((Object)this, "findLibsContaining$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findLibsContaining$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<WebJarLib> __M_findLibsContaining(String path) {
        ArrayList<WebJarLib> list = new ArrayList<WebJarLib>();
        for (WebJarLib lib : this.libs()) {
            if (!lib.contains(path)) continue;
            list.add(lib);
        }
        return list;
    }

    private List<WebJarLib> find(String name) {
        List<WebJarLib> list;
        if (!this.__Mfind$java_lang_String) {
            return this.__M_find(name);
        }
        try {
            this.__IM.onEntry((Object)this, "find$java_lang_String", new Object[]{name});
            list = this.__M_find(name);
            this.__IM.onExit((Object)this, "find$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "find$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<WebJarLib> __M_find(String name) {
        ArrayList<WebJarLib> list = new ArrayList<WebJarLib>();
        for (WebJarLib lib : this.libs()) {
            if (!lib.name.equals(name)) continue;
            list.add(lib);
        }
        return list;
    }

    public List<Route> routes() {
        List<Route> list;
        if (!this.__Mroutes) {
            return this.__M_routes();
        }
        try {
            this.__IM.onEntry((Object)this, "routes", new Object[0]);
            list = this.__M_routes();
            this.__IM.onExit((Object)this, "routes", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "routes", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Route> __M_routes() {
        return ImmutableList.of((Object)new RouteBuilder().route(HttpMethod.GET).on("/libs/{path+}").to((Controller)this, "serve"));
    }

    public Result serve() {
        Result result;
        if (!this.__Mserve) {
            return this.__M_serve();
        }
        try {
            this.__IM.onEntry((Object)this, "serve", new Object[0]);
            result = this.__M_serve();
            this.__IM.onExit((Object)this, "serve", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "serve", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_serve() {
        String path = this.context().parameterFromPath("path");
        if (path == null) {
            this.logger().error("Cannot server Web Jar resource : no path");
            return WebJarController.badRequest();
        }
        Asset<?> asset = this.assetAt(path);
        if (asset == null) {
            return WebJarController.notFound();
        }
        return CacheUtils.fromAsset(this.context(), asset, this.__getconfiguration());
    }

    private WebJarLib find(String name, String version) {
        WebJarLib webJarLib;
        if (!this.__Mfind$java_lang_String$java_lang_String) {
            return this.__M_find(name, version);
        }
        try {
            this.__IM.onEntry((Object)this, "find$java_lang_String$java_lang_String", new Object[]{name, version});
            webJarLib = this.__M_find(name, version);
            this.__IM.onExit((Object)this, "find$java_lang_String$java_lang_String", (Object)webJarLib);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "find$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return webJarLib;
    }

    private WebJarLib __M_find(String name, String version) {
        for (WebJarLib lib : this.libs()) {
            if (!lib.name.equals(name) || !lib.version.equals(version)) continue;
            return lib;
        }
        return null;
    }

    public synchronized List<BundleWebJarLib> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Object object;
        if (!this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent) {
            return this.__M_addingBundle(bundle, bundleEvent);
        }
        try {
            this.__IM.onEntry((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", new Object[]{bundle, bundleEvent});
            object = this.__M_addingBundle(bundle, bundleEvent);
            this.__IM.onExit((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", throwable);
            throw throwable;
        }
        return object;
    }

    private List<BundleWebJarLib> __M_addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Enumeration e = bundle.findEntries(WEBJAR_LOCATION, "*", true);
        if (e == null) {
            return Collections.emptyList();
        }
        ArrayList<BundleWebJarLib> list = new ArrayList<BundleWebJarLib>();
        while (e.hasMoreElements()) {
            Matcher matcher;
            String path = ((URL)e.nextElement()).getPath();
            if (!path.endsWith("/") || !(matcher = WEBJAR_ROOT_REGEX.matcher(path)).matches()) continue;
            String name = matcher.group(1);
            String version = matcher.group(2);
            BundleWebJarLib lib = new BundleWebJarLib(name, version, bundle);
            this.logger().info("Web Jar library ({}) found in {} [{}]", new Object[]{lib, bundle.getSymbolicName(), bundle.getBundleId()});
            list.add(lib);
        }
        this.addWebJarLibs(list);
        return list;
    }

    public void addWebJarLibs(Collection<? extends WebJarLib> list) {
        if (!this.__MaddWebJarLibs$java_util_Collection) {
            this.__M_addWebJarLibs(list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addWebJarLibs$java_util_Collection", new Object[]{list});
            this.__M_addWebJarLibs(list);
            this.__IM.onExit((Object)this, "addWebJarLibs$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addWebJarLibs$java_util_Collection", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_addWebJarLibs(Collection<? extends WebJarLib> list) {
        WebJarController webJarController = this;
        synchronized (webJarController) {
            this.__getlibraries().addAll(list);
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<BundleWebJarLib> webJarLibs) {
        if (!this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List) {
            this.__M_modifiedBundle(bundle, bundleEvent, webJarLibs);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", new Object[]{bundle, bundleEvent, webJarLibs});
            this.__M_modifiedBundle(bundle, bundleEvent, webJarLibs);
            this.__IM.onExit((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<BundleWebJarLib> webJarLibs) {
        WebJarController webJarController = this;
        synchronized (webJarController) {
            this.removedBundle(bundle, bundleEvent, webJarLibs);
            this.addingBundle(bundle, bundleEvent);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<BundleWebJarLib> webJarLibs) {
        if (!this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List) {
            this.__M_removedBundle(bundle, bundleEvent, webJarLibs);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", new Object[]{bundle, bundleEvent, webJarLibs});
            this.__M_removedBundle(bundle, bundleEvent, webJarLibs);
            this.__IM.onExit((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_removedBundle(Bundle bundle, BundleEvent bundleEvent, List<BundleWebJarLib> webJarLibs) {
        this.removeWebJarLibs(webJarLibs);
    }

    public void removeWebJarLibs(Collection<? extends WebJarLib> webJarLibs) {
        if (!this.__MremoveWebJarLibs$java_util_Collection) {
            this.__M_removeWebJarLibs(webJarLibs);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeWebJarLibs$java_util_Collection", new Object[]{webJarLibs});
            this.__M_removeWebJarLibs(webJarLibs);
            this.__IM.onExit((Object)this, "removeWebJarLibs$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeWebJarLibs$java_util_Collection", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_removeWebJarLibs(Collection<? extends WebJarLib> webJarLibs) {
        WebJarController webJarController = this;
        synchronized (webJarController) {
            this.__getlibraries().removeAll(webJarLibs);
        }
    }

    public Collection<Asset<?>> assets() {
        Collection<Asset<?>> collection;
        if (!this.__Massets) {
            return this.__M_assets();
        }
        try {
            this.__IM.onEntry((Object)this, "assets", new Object[0]);
            collection = this.__M_assets();
            this.__IM.onExit((Object)this, "assets", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "assets", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<Asset<?>> __M_assets() {
        ArrayList assets = new ArrayList();
        for (WebJarLib lib : this.__getlibraries()) {
            for (String path : lib.names()) {
                if (path.endsWith("/") || path.startsWith(".")) continue;
                String url = "/libs/" + lib.name + "/" + lib.version + "/" + path;
                DefaultAsset asset = new DefaultAsset(url, lib.get(path), lib.toString(), lib.lastModified(), null);
                assets.add((Asset<?>)asset);
            }
        }
        return assets;
    }

    public Asset<?> assetAt(String path) {
        Asset<?> asset;
        if (!this.__MassetAt$java_lang_String) {
            return this.__M_assetAt(path);
        }
        try {
            this.__IM.onEntry((Object)this, "assetAt$java_lang_String", new Object[]{path});
            asset = this.__M_assetAt(path);
            this.__IM.onExit((Object)this, "assetAt$java_lang_String", asset);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "assetAt$java_lang_String", throwable);
            throw throwable;
        }
        return asset;
    }

    private Asset<?> __M_assetAt(String path) {
        List<WebJarLib> libs;
        String rel;
        List<WebJarLib> candidates = this.findLibsContaining(path);
        if (candidates.size() == 1) {
            return new DefaultAsset("/libs/" + candidates.get((int)0).name + "/" + candidates.get((int)0).version + "/" + path, candidates.get(0).get(path), candidates.get(0).toString(), candidates.get(0).lastModified(), CacheUtils.computeEtag(candidates.get(0).lastModified(), this.__getconfiguration(), this.__getcrypto()));
        }
        if (candidates.size() > 1) {
            this.logger().warn("{} WebJars provide '{}' - returning the one from {}-{}", new Object[]{candidates.size(), path, candidates.get((int)0).name, candidates.get((int)0).version});
            return new DefaultAsset("/libs/" + candidates.get((int)0).name + "/" + candidates.get((int)0).version + "/" + path, candidates.get(0).get(path), candidates.get(0).toString(), candidates.get(0).lastModified(), CacheUtils.computeEtag(candidates.get(0).lastModified(), this.__getconfiguration(), this.__getcrypto()));
        }
        Matcher matcher = PATTERN.matcher(path);
        if (!matcher.matches()) {
            return null;
        }
        String name = matcher.group(1);
        String version = matcher.group(3);
        if (version != null) {
            rel = matcher.group(4);
            WebJarLib lib = this.find(name, version);
            if (lib != null) {
                return new DefaultAsset(rel, lib.get(rel), lib.toString(), lib.lastModified(), CacheUtils.computeEtag(lib.lastModified(), this.__getconfiguration(), this.__getcrypto()));
            }
        }
        rel = matcher.group(4);
        if (version != null) {
            rel = version + "/" + rel;
        }
        if ((libs = this.find(name)).size() == 1) {
            if (libs.get(0).contains(rel)) {
                WebJarLib lib = libs.get(0);
                return new DefaultAsset("/libs/" + lib.name + "/" + lib.version + "/" + rel, lib.get(rel), lib.toString(), lib.lastModified(), CacheUtils.computeEtag(lib.lastModified(), this.__getconfiguration(), this.__getcrypto()));
            }
        } else if (libs.size() > 1) {
            for (WebJarLib lib : this.libs()) {
                if (!lib.contains(rel)) continue;
                this.logger().warn("{} WebJars match the request '{}' - returning the resource from {}-{}", new Object[]{libs.size(), path, lib.name, lib.version});
                return new DefaultAsset("/libs/" + lib.name + "/" + lib.version + "/" + rel, lib.get(rel), lib.toString(), lib.lastModified(), CacheUtils.computeEtag(lib.lastModified(), this.__getconfiguration(), this.__getcrypto()));
            }
        }
        return null;
    }

    private void __M_removedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.removedBundle(bundle, bundleEvent, (List)object);
    }

    private void __M_modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.modifiedBundle(bundle, bundleEvent, (List)object);
    }

    private Object __M_addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        return this.addingBundle(bundle, bundleEvent);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("crypto")) {
                this.__Fcrypto = true;
            }
            if (set.contains("deployer")) {
                this.__Fdeployer = true;
            }
            if (set.contains("directory")) {
                this.__Fdirectory = true;
            }
            if (set.contains("libraries")) {
                this.__Flibraries = true;
            }
            if (set.contains("tracker")) {
                this.__Ftracker = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___compare$org_wisdom_resources_WebJarLib$org_wisdom_resources_WebJarLib")) {
                this.__M1___compare$org_wisdom_resources_WebJarLib$org_wisdom_resources_WebJarLib = true;
            }
            if (set.contains("1___compare$java_lang_Object$java_lang_Object")) {
                this.__M1___compare$java_lang_Object$java_lang_Object = true;
            }
            if (set.contains("2___accept$java_io_File")) {
                this.__M2___accept$java_io_File = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("buildFileIndex")) {
                this.__MbuildFileIndex = true;
            }
            if (set.contains("indexSize")) {
                this.__MindexSize = true;
            }
            if (set.contains("libs")) {
                this.__Mlibs = true;
            }
            if (set.contains("findLibsContaining$java_lang_String")) {
                this.__MfindLibsContaining$java_lang_String = true;
            }
            if (set.contains("find$java_lang_String")) {
                this.__Mfind$java_lang_String = true;
            }
            if (set.contains("routes")) {
                this.__Mroutes = true;
            }
            if (set.contains("serve")) {
                this.__Mserve = true;
            }
            if (set.contains("find$java_lang_String$java_lang_String")) {
                this.__Mfind$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent")) {
                this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent = true;
            }
            if (set.contains("addWebJarLibs$java_util_Collection")) {
                this.__MaddWebJarLibs$java_util_Collection = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List = true;
            }
            if (set.contains("removeWebJarLibs$java_util_Collection")) {
                this.__MremoveWebJarLibs$java_util_Collection = true;
            }
            if (set.contains("assets")) {
                this.__Massets = true;
            }
            if (set.contains("assetAt$java_lang_String")) {
                this.__MassetAt$java_lang_String = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public WebJarController(InstanceManager instanceManager) {
        this._setInstanceManager(instanceManager);
    }
}

