/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.resources;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.services.ExtensionBasedDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.resources.FileWebJarLib;
import org.wisdom.resources.WebJarController;

public class WebJarDeployer
extends ExtensionBasedDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebJarDeployer.class);
    private final BundleContext context;
    private final File cache;
    private final WebJarController controller;
    private Set<FileWebJarLib> libs = new LinkedHashSet<FileWebJarLib>();
    private ServiceRegistration<Deployer> reg;

    public WebJarDeployer(BundleContext context, WebJarController webJarController) {
        super("jar");
        this.context = context;
        this.controller = webJarController;
        this.cache = context.getBundle().getDataFile("webjars");
        if (!this.cache.isDirectory()) {
            boolean made = this.cache.mkdirs();
            LOGGER.debug("Creating webjars directory : {}", (Object)made);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onFileCreate(File file) {
        Set<DetectedWebJar> listOfDetectedWebJarLib = WebJarDeployer.isWebJar(file);
        if (listOfDetectedWebJarLib != null) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                ArrayList<FileWebJarLib> installed = new ArrayList<FileWebJarLib>();
                for (DetectedWebJar detected : listOfDetectedWebJarLib) {
                    FileWebJarLib lib = this.expand(detected, jar);
                    if (lib == null) continue;
                    this.libs.add(lib);
                    installed.add(lib);
                    LOGGER.info("{} unpacked to {}", (Object)lib.name, (Object)lib.root.getAbsolutePath());
                }
                this.controller.addWebJarLibs(installed);
            }
            catch (IOException e) {
                try {
                    LOGGER.error("Cannot open the jar file {}", (Object)file.getAbsolutePath(), (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(jar);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)jar);
            }
            IOUtils.closeQuietly((Closeable)jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWebJarLib expand(DetectedWebJar lib, JarFile jar) {
        File out = new File(this.cache, lib.id);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith("META-INF/resources/webjars/") || entry.isDirectory()) continue;
            File output = new File(out, entry.getName().substring("META-INF/resources/webjars/".length()));
            InputStream stream = null;
            try {
                stream = jar.getInputStream(entry);
                boolean made = output.getParentFile().mkdirs();
                LOGGER.debug("{} directory created : {} ", (Object)output.getParentFile().getAbsolutePath(), (Object)made);
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)output);
            }
            catch (IOException e) {
                LOGGER.error("Cannot unpack " + entry.getName() + " from " + lib.file.getName(), (Throwable)e);
                FileWebJarLib fileWebJarLib = null;
                return fileWebJarLib;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        File root = new File(out, lib.name + "/" + lib.version);
        return new FileWebJarLib(lib.name, lib.version, root, lib.file.getName());
    }

    public synchronized void onFileChange(File file) {
        this.onFileDelete(file);
        this.onFileCreate(file);
    }

    public synchronized void onFileDelete(File file) {
        LinkedHashSet<FileWebJarLib> copy = new LinkedHashSet<FileWebJarLib>(this.libs);
        ArrayList<FileWebJarLib> toRemove = new ArrayList<FileWebJarLib>();
        for (FileWebJarLib lib : copy) {
            if (lib.source == null || !lib.source.equals(file.getName())) continue;
            this.libs.remove(lib);
            toRemove.add(lib);
            FileUtils.deleteQuietly((File)lib.root);
        }
        this.controller.removeWebJarLibs(toRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DetectedWebJar> isWebJar(File file) {
        block8: {
            JarFile finalJar;
            JarFile jar;
            LinkedHashSet<DetectedWebJar> found;
            block7: {
                found = new LinkedHashSet<DetectedWebJar>();
                if (!file.isFile() || !file.getName().endsWith(".jar")) break block8;
                jar = null;
                jar = new JarFile(file);
                if (jar.getEntry("META-INF/resources/webjars/") != null) break block7;
                Set<DetectedWebJar> set = null;
                JarFile finalJar2 = jar;
                IOUtils.closeQuietly((Closeable)new Closeable(finalJar2){
                    final /* synthetic */ JarFile val$finalJar;
                    {
                        this.val$finalJar = jarFile;
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.val$finalJar != null) {
                            this.val$finalJar.close();
                        }
                    }
                });
                return set;
            }
            try {
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    Matcher matcher = WebJarController.WEBJAR_REGEX.matcher(entry.getName());
                    if (!matcher.matches()) continue;
                    found.add(new DetectedWebJar(matcher.group(1), matcher.group(2), entry.getName(), file));
                }
                finalJar = jar;
            }
            catch (IOException e) {
                JarFile finalJar3;
                Set<DetectedWebJar> entry;
                try {
                    LOGGER.error("Cannot check if the file {} is a webjar, cannot open it", (Object)file.getName(), (Object)e);
                    entry = null;
                    finalJar3 = jar;
                }
                catch (Throwable throwable) {
                    JarFile finalJar4 = jar;
                    IOUtils.closeQuietly((Closeable)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)new /* invalid duplicate definition of identical inner class */);
                return entry;
            }
            IOUtils.closeQuietly((Closeable)new /* invalid duplicate definition of identical inner class */);
            for (DetectedWebJar lib : found) {
                LOGGER.info("Web Library found in {} : {}", (Object)file.getName(), (Object)lib.id);
            }
            return found;
        }
        return null;
    }

    public synchronized void start() {
        this.reg = this.context.registerService(Deployer.class, (Object)this, null);
    }

    public synchronized void stop() {
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    private static final class DetectedWebJar {
        public final String id;
        public final String name;
        public final String version;
        public final String path;
        public final File file;

        private DetectedWebJar(String name, String version, String path, File file) {
            this.name = name;
            this.version = version;
            this.path = path;
            this.id = name + "-" + version;
            this.file = file;
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(DetectedWebJar.class) && this.id.equals(((DetectedWebJar)obj).id);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }
    }
}

