/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Unbind;
import org.ow2.shelbie.core.internal.registry.AggregatedScopeInfo;
import org.ow2.shelbie.core.registry.CommandFilter;
import org.ow2.shelbie.core.registry.CommandRegistry;
import org.ow2.shelbie.core.registry.info.CommandInfo;
import org.ow2.shelbie.core.registry.info.ScopeInfo;
import org.ow2.shelbie.core.registry.supply.InfoSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class DefaultCommandRegistry
implements CommandRegistry,
Pojo {
    private InstanceManager __IM;
    private boolean __Fsuppliers;
    private List<InfoSupplier> suppliers;
    private boolean __MgetScopes;
    private boolean __MgetAllCommands;
    private boolean __MgetCommands$org_ow2_shelbie_core_registry_CommandFilter;
    private boolean __MbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier;
    private boolean __MunbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier;
    private boolean __MfindScopeInfo$java_util_Map$java_lang_String;

    List __getsuppliers() {
        if (!this.__Fsuppliers) {
            return this.suppliers;
        }
        return (List)this.__IM.onGet((Object)this, "suppliers");
    }

    void __setsuppliers(List list) {
        if (!this.__Fsuppliers) {
            this.suppliers = list;
            return;
        }
        this.__IM.onSet((Object)this, "suppliers", (Object)list);
    }

    public DefaultCommandRegistry() {
        this(null);
    }

    private DefaultCommandRegistry(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setsuppliers(new ArrayList());
    }

    @Override
    public Collection<? extends ScopeInfo> getScopes() {
        Collection<? extends ScopeInfo> collection;
        if (!this.__MgetScopes) {
            return this.__M_getScopes();
        }
        try {
            this.__IM.onEntry((Object)this, "getScopes", new Object[0]);
            collection = this.__M_getScopes();
            this.__IM.onExit((Object)this, "getScopes", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getScopes", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<? extends ScopeInfo> __M_getScopes() {
        HashMap<String, AggregatedScopeInfo> scopes = new HashMap<String, AggregatedScopeInfo>();
        for (InfoSupplier supplier : this.__getsuppliers()) {
            Collection<ScopeInfo> supplied = supplier.getScopeInfo();
            for (ScopeInfo scopeInfo : supplied) {
                AggregatedScopeInfo asi = this.findScopeInfo(scopes, scopeInfo.getName());
                asi.addScopeInfo(scopeInfo);
            }
        }
        return scopes.values();
    }

    @Override
    public Collection<? extends CommandInfo> getAllCommands() {
        Collection<? extends CommandInfo> collection;
        if (!this.__MgetAllCommands) {
            return this.__M_getAllCommands();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllCommands", new Object[0]);
            collection = this.__M_getAllCommands();
            this.__IM.onExit((Object)this, "getAllCommands", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllCommands", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<? extends CommandInfo> __M_getAllCommands() {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        for (ScopeInfo scopeInfo : this.getScopes()) {
            commands.addAll(scopeInfo.getCommands());
        }
        return commands;
    }

    @Override
    public Collection<? extends CommandInfo> getCommands(CommandFilter filter) {
        Collection<? extends CommandInfo> collection;
        if (!this.__MgetCommands$org_ow2_shelbie_core_registry_CommandFilter) {
            return this.__M_getCommands(filter);
        }
        try {
            this.__IM.onEntry((Object)this, "getCommands$org_ow2_shelbie_core_registry_CommandFilter", new Object[]{filter});
            collection = this.__M_getCommands(filter);
            this.__IM.onExit((Object)this, "getCommands$org_ow2_shelbie_core_registry_CommandFilter", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCommands$org_ow2_shelbie_core_registry_CommandFilter", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<? extends CommandInfo> __M_getCommands(CommandFilter filter) {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        for (CommandInfo commandInfo : this.getAllCommands()) {
            if (!filter.accept(commandInfo)) continue;
            commands.add(commandInfo);
        }
        return commands;
    }

    public void bindInfoSupplier(InfoSupplier supplier) {
        if (!this.__MbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier) {
            this.__M_bindInfoSupplier(supplier);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier", new Object[]{supplier});
            this.__M_bindInfoSupplier(supplier);
            this.__IM.onExit((Object)this, "bindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __M_bindInfoSupplier(InfoSupplier supplier) {
        this.__getsuppliers().add(supplier);
    }

    public void unbindInfoSupplier(InfoSupplier supplier) {
        if (!this.__MunbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier) {
            this.__M_unbindInfoSupplier(supplier);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier", new Object[]{supplier});
            this.__M_unbindInfoSupplier(supplier);
            this.__IM.onExit((Object)this, "unbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindInfoSupplier(InfoSupplier supplier) {
        this.__getsuppliers().remove(supplier);
    }

    private AggregatedScopeInfo findScopeInfo(Map<String, AggregatedScopeInfo> scopes, String scope) {
        AggregatedScopeInfo aggregatedScopeInfo;
        if (!this.__MfindScopeInfo$java_util_Map$java_lang_String) {
            return this.__M_findScopeInfo(scopes, scope);
        }
        try {
            this.__IM.onEntry((Object)this, "findScopeInfo$java_util_Map$java_lang_String", new Object[]{scopes, scope});
            aggregatedScopeInfo = this.__M_findScopeInfo(scopes, scope);
            this.__IM.onExit((Object)this, "findScopeInfo$java_util_Map$java_lang_String", (Object)aggregatedScopeInfo);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findScopeInfo$java_util_Map$java_lang_String", throwable);
            throw throwable;
        }
        return aggregatedScopeInfo;
    }

    private AggregatedScopeInfo __M_findScopeInfo(Map<String, AggregatedScopeInfo> scopes, String scope) {
        AggregatedScopeInfo asi = scopes.get(scope);
        if (asi == null) {
            asi = new AggregatedScopeInfo(scope);
            scopes.put(scope, asi);
        }
        return asi;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("suppliers")) {
            this.__Fsuppliers = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getScopes")) {
                this.__MgetScopes = true;
            }
            if (set.contains("getAllCommands")) {
                this.__MgetAllCommands = true;
            }
            if (set.contains("getCommands$org_ow2_shelbie_core_registry_CommandFilter")) {
                this.__MgetCommands$org_ow2_shelbie_core_registry_CommandFilter = true;
            }
            if (set.contains("bindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier")) {
                this.__MbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier = true;
            }
            if (set.contains("unbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier")) {
                this.__MunbindInfoSupplier$org_ow2_shelbie_core_registry_supply_InfoSupplier = true;
            }
            if (set.contains("findScopeInfo$java_util_Map$java_lang_String")) {
                this.__MfindScopeInfo$java_util_Map$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

