/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import java.nio.charset.Charset;
import org.assertj.core.api.AbstractAssert;
import org.wisdom.test.assertions.SessionAssert;
import org.wisdom.test.assertions.StatusAssert;
import org.wisdom.test.parents.Action;

public class ActionResultAssert
extends AbstractAssert<ActionResultAssert, Action.ActionResult> {
    protected ActionResultAssert(Action.ActionResult actual) {
        super((Object)actual, ActionResultAssert.class);
    }

    public static ActionResultAssert assertThat(Action.ActionResult actual) {
        return new ActionResultAssert(actual).isNotNull();
    }

    public StatusAssert status() {
        this.isNotNull();
        return StatusAssert.assertThat(((Action.ActionResult)this.actual).getResult().getStatusCode());
    }

    public ActionResultAssert hasStatus(Integer statusCode) {
        this.isNotNull();
        if (((Action.ActionResult)this.actual).getResult().getStatusCode() != statusCode.intValue()) {
            this.failWithMessage("Expected status to be <%s> but was <%s>", new Object[]{statusCode, ((Action.ActionResult)this.actual).getResult().getStatusCode()});
        }
        return this;
    }

    public ActionResultAssert hasContentType(String contentType) {
        this.isNotNull();
        if (!((Action.ActionResult)this.actual).getResult().getContentType().equals(contentType)) {
            this.failWithMessage("Expected content type to be <%s> but was <%s>", new Object[]{contentType, ((Action.ActionResult)this.actual).getResult().getContentType()});
        }
        return this;
    }

    public ActionResultAssert hasFullContentType(String fullContentType) {
        this.isNotNull();
        if (!((Action.ActionResult)this.actual).getResult().getFullContentType().equals(fullContentType)) {
            this.failWithMessage("Expected content type to be <%s> but was <%s>", new Object[]{fullContentType, ((Action.ActionResult)this.actual).getResult().getFullContentType()});
        }
        return this;
    }

    public ActionResultAssert hasCharset(Charset charset) {
        this.isNotNull();
        if (!((Action.ActionResult)this.actual).getResult().getCharset().equals(charset)) {
            this.failWithMessage("Expected charset to be <%s> but was <%s>", new Object[]{charset.displayName(), ((Action.ActionResult)this.actual).getResult().getCharset().displayName()});
        }
        return this;
    }

    public ActionResultAssert hasInSession(String key, String value) {
        this.isNotNull();
        SessionAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).containsEntry(key, value);
        return this;
    }

    public ActionResultAssert doesNotHaveInSession(String key) {
        this.isNotNull();
        SessionAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).doesNotContain(key);
        return this;
    }

    public ActionResultAssert sessionIsEmpty() {
        this.isNotNull();
        SessionAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).isEmpty();
        return this;
    }

    public ActionResultAssert sessionIsNotEmpty() {
        this.isNotNull();
        SessionAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).isNotEmpty();
        return this;
    }

    public <T> ActionResultAssert hasContent(Class<T> klass, T body) {
        this.isNotNull();
        Object content = ((Action.ActionResult)this.actual).getResult().getRenderable().content();
        if (content == null) {
            this.failWithMessage("Expected content to not be null", new Object[0]);
            return this;
        }
        if (!klass.isInstance(content)) {
            this.failWithMessage("Expected content to be a <%s> but was a <%s>", new Object[]{klass.getName(), content.getClass().getName()});
        }
        if (!content.equals(body)) {
            this.failWithMessage("Expected content to be <%s> but was <%s>", new Object[]{body, content});
        }
        return this;
    }

    public ActionResultAssert hasContent(String content) {
        this.isNotNull();
        Object body = ((Action.ActionResult)this.actual).getResult().getRenderable().content();
        if (body == null) {
            this.failWithMessage("Expected content to not be null", new Object[0]);
            return this;
        }
        if (!content.equals(body.toString())) {
            this.failWithMessage("Expected content to be <%s> but was <%s>", new Object[]{content, content});
        }
        return this;
    }

    public ActionResultAssert hasInContent(String inBody) {
        this.isNotNull();
        Object content = ((Action.ActionResult)this.actual).getResult().getRenderable().content();
        if (content == null) {
            this.failWithMessage("Expected content to not be null", new Object[0]);
            return this;
        }
        if (!content.toString().contains(inBody)) {
            this.failWithMessage("Expected content to contain <%s> but was <%s>", new Object[]{inBody, content.toString()});
        }
        return this;
    }

    public ActionResultAssert hasContentMatch(String regex) {
        this.isNotNull();
        Object content = ((Action.ActionResult)this.actual).getResult().getRenderable().content();
        if (content == null) {
            this.failWithMessage("Expected content to not be null", new Object[0]);
            return this;
        }
        if (!content.toString().matches(regex)) {
            this.failWithMessage("Expected content to match <%s> but was <%s>", new Object[]{regex, content.toString()});
        }
        return this;
    }

    public ActionResultAssert isNotNull() {
        super.isNotNull();
        if (((Action.ActionResult)this.actual).getResult() == null) {
            this.failWithMessage("Result should not be null", new Object[0]);
        }
        return this;
    }

    public ActionResultAssert hasHeader(String headerName) {
        super.isNotNull();
        if (!((Action.ActionResult)this.actual).getResult().getHeaders().containsKey(headerName)) {
            this.failWithMessage("Header <%s> expected in <%s>", new Object[]{headerName, ((Action.ActionResult)this.actual).getResult().getHeaders()});
        }
        return this;
    }
}

