/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import org.assertj.core.api.AbstractAssert;
import org.wisdom.api.cookies.SessionCookie;

public class SessionAssert
extends AbstractAssert<SessionAssert, SessionCookie> {
    protected SessionAssert(SessionCookie actual) {
        super((Object)actual, SessionAssert.class);
    }

    public static SessionAssert assertThat(SessionCookie actual) {
        return new SessionAssert(actual);
    }

    public SessionAssert isEmpty() {
        this.isNotNull();
        if (!((SessionCookie)this.actual).isEmpty()) {
            this.failWithMessage("Expected session to be empty", new Object[0]);
        }
        return this;
    }

    public SessionAssert isNotEmpty() {
        this.isNotNull();
        if (((SessionCookie)this.actual).isEmpty()) {
            this.failWithMessage("Expected session not to be empty", new Object[0]);
        }
        return this;
    }

    public SessionAssert containsEntry(String key, String value) {
        this.isNotNull();
        this.isNotEmpty();
        if (!value.equals(((SessionCookie)this.actual).get(key))) {
            this.failWithMessage("Expected session to contain entry <%s, %s> but value was <%s>", new Object[]{key, value, String.valueOf(((SessionCookie)this.actual).get(key))});
        }
        return this;
    }

    public SessionAssert doesNotContain(String key) {
        this.isNotNull();
        this.isNotEmpty();
        if (((SessionCookie)this.actual).getData().containsKey(key)) {
            this.failWithMessage("Expected session to not contain key '%s'", new Object[]{key});
        }
        return this;
    }
}

