/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.ow2.chameleon.testing.helpers.TimeUtils;

public class Options {
    public static final long CONNECTION_TIMEOUT = 10000L;
    private static final long SOCKET_TIMEOUT = 60000L;
    private static final Map<Option, Object> options = new HashMap<Option, Object>();

    public static void setOption(Option option, Object value) {
        options.put(option, value);
    }

    public static Object getOption(Option option) {
        return options.get((Object)option);
    }

    public static void refresh() {
        Object socketTimeout;
        Object connectionTimeout = Options.getOption(Option.CONNECTION_TIMEOUT);
        if (connectionTimeout == null) {
            connectionTimeout = 10000L;
        }
        if ((socketTimeout = Options.getOption(Option.SOCKET_TIMEOUT)) == null) {
            socketTimeout = 60000L;
        }
        BasicCookieStore store = new BasicCookieStore();
        RequestConfig clientConfig = RequestConfig.custom().setConnectTimeout(((Long)connectionTimeout).intValue() * TimeUtils.TIME_FACTOR).setSocketTimeout(((Long)socketTimeout).intValue() * TimeUtils.TIME_FACTOR).setConnectionRequestTimeout(((Long)socketTimeout).intValue() * TimeUtils.TIME_FACTOR).setCookieSpec("standard").build();
        Options.setOption(Option.HTTPCLIENT, HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setDefaultCookieStore((CookieStore)store).build());
        Options.setOption(Option.COOKIES, store);
        CloseableHttpAsyncClient asyncClient = HttpAsyncClientBuilder.create().setDefaultRequestConfig(clientConfig).setDefaultCookieStore((CookieStore)store).build();
        Options.setOption(Option.ASYNCHTTPCLIENT, asyncClient);
    }

    static {
        Options.refresh();
    }

    public static enum Option {
        HTTPCLIENT,
        ASYNCHTTPCLIENT,
        CONNECTION_TIMEOUT,
        SOCKET_TIMEOUT,
        DEFAULT_HEADERS,
        COOKIES;

    }
}

