/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.wisdom.api.configuration.Configuration;

public class FakeConfiguration
implements Configuration {
    private final Map<String, Object> internals;

    public FakeConfiguration(Map<String, Object> map) {
        this.internals = map;
    }

    public Configuration getConfiguration(String prefix) {
        return (Configuration)this.internals.get(prefix);
    }

    public boolean has(String key) {
        return this.internals.containsKey(key);
    }

    public String get(String key) {
        return (String)this.internals.get(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        return (T)this.internals.get(key);
    }

    public <T> T getOrDie(String key, Class<T> clazz) {
        T result = this.get(key, clazz);
        if (result == null) {
            throw new RuntimeException("Missing key " + key);
        }
        return result;
    }

    public <T> T get(String key, Class<T> clazz, T defaultValue) {
        T result = this.get(key, clazz);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public <T> T get(String key, Class<T> clazz, String defaultValueAsString) {
        T result = this.get(key, clazz);
        if (result == null) {
            throw new UnsupportedOperationException("No conversion in FakeConfiguration");
        }
        return result;
    }

    public String getWithDefault(String key, String defaultValue) {
        String result = (String)this.internals.get(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public Integer getInteger(String key) {
        return this.get(key, Integer.class);
    }

    public Integer getIntegerWithDefault(String key, Integer defaultValue) {
        return this.get(key, Integer.class, defaultValue);
    }

    public Double getDouble(String key) {
        return this.get(key, Double.class);
    }

    public Double getDoubleWithDefault(String key, Double defaultValue) {
        return this.get(key, Double.class, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Boolean getBooleanWithDefault(String key, Boolean defaultValue) {
        return this.get(key, Boolean.class, defaultValue);
    }

    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    public Long getLongWithDefault(String key, Long defaultValue) {
        return this.get(key, Long.class, defaultValue);
    }

    public Long getLongOrDie(String key) {
        return this.getOrDie(key, Long.class);
    }

    public Boolean getBooleanOrDie(String key) {
        return this.getOrDie(key, Boolean.class);
    }

    public Integer getIntegerOrDie(String key) {
        return this.getOrDie(key, Integer.class);
    }

    public Double getDoubleOrDie(String key) {
        return this.getOrDie(key, Double.class);
    }

    public String getOrDie(String key) {
        String r = this.get(key);
        if (r == null) {
            throw new RuntimeException("Missing key : " + key);
        }
        return r;
    }

    public Long getDuration(String key, TimeUnit unit) {
        return this.getLong(key);
    }

    public Long getDuration(String key, TimeUnit unit, long defaultValue) {
        return this.getLongWithDefault(key, defaultValue);
    }

    public Long getBytes(String key) {
        return this.getLong(key);
    }

    public Long getBytes(String key, long defaultValue) {
        return this.getLongWithDefault(key, defaultValue);
    }

    public String[] getStringArray(String key) {
        String[] array = (String[])this.internals.get(key);
        if (array == null) {
            return new String[0];
        }
        return array;
    }

    public List<String> getList(String key) {
        List list = (List)this.internals.get(key);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        properties.putAll(this.internals);
        return properties;
    }

    public Map<String, Object> asMap() {
        return new HashMap<String, Object>(this.internals);
    }
}

