/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.test.internals.ChameleonExecutor;

public class WisdomBlackBoxRunner
extends BlockJUnit4ClassRunner
implements Filterable,
Sortable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomBlackBoxRunner.class);

    public WisdomBlackBoxRunner(Class<?> klass) throws Exception {
        super(klass);
        File basedir = this.checkWisdomInstallation();
        File bundle = this.detectApplicationBundleIfExist(new File(basedir, "application"));
        if (bundle != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the application directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            bundle.delete();
        }
        if ((bundle = this.detectApplicationBundleIfExist(new File(basedir, "runtime"))) != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the runtime directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            bundle.delete();
        }
        System.setProperty("application.configuration", new File(basedir, "/conf/application.conf").getAbsolutePath());
        ChameleonExecutor executor = ChameleonExecutor.instance(basedir);
        executor.deployApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File detectApplicationBundleIfExist(File directory) throws IOException {
        if (!directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        final File classes = new File("target/classes");
        Collection clazzes = FileUtils.listFiles((File)classes, (String[])new String[]{"class"}, (boolean)true);
        Collection classnames = Collections2.transform((Collection)clazzes, (Function)new Function<File, String>(){

            public String apply(File input) {
                String absolute = input.getAbsolutePath();
                return absolute.substring(classes.getAbsolutePath().length() + 1);
            }
        });
        for (File file : files) {
            File file2;
            if (!file.getName().endsWith("jar")) continue;
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".class") || !classnames.contains(entry.getName())) break block7;
                    file2 = file;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jar);
                throw throwable;
            }
            {
                block7: {
                    IOUtils.closeQuietly((Closeable)jar);
                    return file2;
                }
                continue;
            }
            IOUtils.closeQuietly((Closeable)jar);
        }
        return null;
    }

    private File checkWisdomInstallation() {
        File directory = new File("target/wisdom");
        if (!directory.isDirectory()) {
            throw new ExceptionInInitializerError("Wisdom is not installed in " + directory.getAbsolutePath() + " - " + "please check your execution directory, and that Wisdom is prepared correctly. To setup Wisdom, " + "run 'mvn pre-integration-test' from your application directory");
        }
        File conf = new File(directory, "conf/application.conf");
        if (!conf.isFile()) {
            throw new ExceptionInInitializerError("Wisdom is not correctly installed in " + directory.getAbsolutePath() + " - the configuration file does not exist. Please check your Wisdom runtime. To setup Wisdom, " + "run 'mvn clean pre-integration-test' from your application directory");
        }
        return directory;
    }

    public void sort(Sorter sorter) {
        super.sort(sorter);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        super.filter(filter);
    }
}

