/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.test.internals.ChameleonExecutor;
import org.wisdom.test.shared.InVivoRunner;

public class WisdomRunner
extends BlockJUnit4ClassRunner
implements Filterable,
Sortable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomRunner.class);
    private final InVivoRunner delegate;

    public WisdomRunner(Class<?> klass) throws Exception {
        super(klass);
        File basedir = this.checkWisdomInstallation();
        File bundle = this.detectApplicationBundleIfExist(new File(basedir, "application"));
        if (bundle != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the application directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            bundle.delete();
        }
        if ((bundle = this.detectApplicationBundleIfExist(new File(basedir, "runtime"))) != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the runtime directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            bundle.delete();
        }
        System.setProperty("application.configuration", new File(basedir, "/conf/application.conf").getAbsolutePath());
        ChameleonExecutor executor = ChameleonExecutor.instance(basedir);
        executor.deployApplication();
        executor.deployProbe();
        this.delegate = executor.getInVivoRunnerInstance(klass);
    }

    private File detectApplicationBundleIfExist(File directory) throws IOException {
        String version;
        String strippedVersion;
        Properties properties = WisdomRunner.getMavenProperties();
        if (properties == null || directory == null || !directory.isDirectory()) {
            return null;
        }
        final String artifactId = properties.getProperty("project.artifactId");
        Iterator files = FileUtils.iterateFiles((File)directory, (IOFileFilter)new AbstractFileFilter(strippedVersion = (version = properties.getProperty("project.version")).endsWith("-SNAPSHOT") ? version.substring(0, version.length() - "-SNAPSHOT".length()) : version){
            final /* synthetic */ String val$strippedVersion;
            {
                this.val$strippedVersion = string2;
            }

            public boolean accept(File file) {
                return file.isFile() && file.getName().startsWith(artifactId + "-" + this.val$strippedVersion) && file.getName().endsWith(".jar");
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (files.hasNext()) {
            return (File)files.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getMavenProperties() throws IOException {
        File osgi = new File("target/osgi/osgi.properties");
        if (osgi.isFile()) {
            Properties properties;
            FileInputStream fis = null;
            try {
                Properties read = new Properties();
                fis = new FileInputStream(osgi);
                read.load(fis);
                properties = read;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return properties;
        }
        return null;
    }

    private File checkWisdomInstallation() {
        File directory = new File("target/wisdom");
        if (!directory.isDirectory()) {
            throw new ExceptionInInitializerError("Wisdom is not installed in " + directory.getAbsolutePath() + " - " + "please check your execution directory, and that Wisdom is prepared correctly. To setup Wisdom, " + "run 'mvn pre-integration-test' from your application directory");
        }
        File conf = new File(directory, "conf/application.conf");
        if (!conf.isFile()) {
            throw new ExceptionInInitializerError("Wisdom is not correctly installed in " + directory.getAbsolutePath() + " - the configuration file does not exist. Please check your Wisdom runtime. To setup Wisdom, " + "run 'mvn clean pre-integration-test' from your application directory");
        }
        return directory;
    }

    protected Object createTest() throws Exception {
        return this.delegate.createTest();
    }

    public void run(RunNotifier notifier) {
        this.delegate.run(notifier);
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.delegate.filter(filter);
    }

    public void sort(Sorter sorter) {
        this.delegate.sort(sorter);
    }
}

