/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import org.junit.Before;
import org.junit.runner.RunWith;
import org.osgi.framework.ServiceReference;
import org.wisdom.api.engine.WisdomEngine;
import org.wisdom.api.http.HeaderNames;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Status;
import org.wisdom.test.WisdomBlackBoxRunner;
import org.wisdom.test.http.GetRequest;
import org.wisdom.test.http.HttpRequestWithBody;
import org.wisdom.test.internals.ChameleonExecutor;

@RunWith(value=WisdomBlackBoxRunner.class)
public class WisdomBlackBoxTest
implements HeaderNames,
Status {
    private String hostname;
    private int httpPort;

    @Before
    public void retrieveServerMetadata() throws Exception {
        if (this.hostname != null) {
            return;
        }
        ServiceReference reference = ChameleonExecutor.instance(null).context().getServiceReference(WisdomEngine.class.getName());
        Object engine = ChameleonExecutor.instance(null).context().getService(reference);
        this.hostname = (String)engine.getClass().getMethod("hostname", new Class[0]).invoke(engine, new Object[0]);
        this.httpPort = (Integer)engine.getClass().getMethod("httpPort", new Class[0]).invoke(engine, new Object[0]);
    }

    public String getHttpURl(String path) {
        String localUrl = path;
        if (localUrl.startsWith("http")) {
            return localUrl;
        }
        if (!localUrl.startsWith("/")) {
            localUrl = '/' + localUrl;
        }
        return "http://" + this.hostname + ":" + this.httpPort + localUrl;
    }

    public GetRequest get(String url) {
        return new GetRequest(HttpMethod.GET, this.getHttpURl(url));
    }

    public HttpRequestWithBody post(String url) {
        return new HttpRequestWithBody(HttpMethod.POST, this.getHttpURl(url));
    }

    public HttpRequestWithBody delete(String url) {
        return new HttpRequestWithBody(HttpMethod.DELETE, this.getHttpURl(url));
    }

    public HttpRequestWithBody put(String url) {
        return new HttpRequestWithBody(HttpMethod.PUT, this.getHttpURl(url));
    }
}

