/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.shared;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InVivoClassLoader
extends ClassLoader {
    private final BundleContext context;
    private final String testClass;

    public InVivoClassLoader(String clazz, BundleContext context) {
        this.context = context;
        this.testClass = clazz;
    }

    private byte[] loadBytecode(String classname) throws IOException {
        URL resource = this.context.getBundle().getResource(classname.replace(".", "/") + ".class");
        if (resource == null) {
            throw new IOException("Cannot load the bytecode of " + classname);
        }
        return IOUtils.toByteArray((URL)resource);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.equals(this.testClass) || name.startsWith(this.testClass + "$")) {
            try {
                byte[] bytes = this.loadBytecode(name);
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot define class " + name + " - did not find the .class file", e);
            }
        }
        try {
            return this.context.getBundle().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            List<Bundle> bundles = Arrays.asList(this.context.getBundles());
            Collections.reverse(bundles);
            for (Bundle bundle : bundles) {
                try {
                    return bundle.loadClass(name);
                }
                catch (ClassNotFoundException e2) {
                }
            }
            return super.loadClass(name);
        }
    }
}

