/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.internals;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.runners.model.InitializationError;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.core.Chameleon;
import org.ow2.chameleon.core.ChameleonConfiguration;
import org.ow2.chameleon.testing.helpers.Stability;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.wisdom.maven.utils.BundlePackager;
import org.wisdom.test.internals.Packages;
import org.wisdom.test.internals.ProbeBundleMaker;
import org.wisdom.test.shared.InVivoRunner;
import org.wisdom.test.shared.InVivoRunnerFactory;

public class ChameleonExecutor {
    private static final String APPLICATION_BUNDLE = "target/osgi/application.jar";
    private static ChameleonExecutor INSTANCE;
    private Chameleon chameleon;

    private ChameleonExecutor() {
    }

    public static synchronized ChameleonExecutor instance(File root) throws BundleException, IOException {
        if (INSTANCE == null) {
            File application = new File(APPLICATION_BUNDLE);
            if (application.isFile()) {
                FileUtils.deleteQuietly((File)application);
            }
            INSTANCE = new ChameleonExecutor();
            INSTANCE.start(root);
        }
        return INSTANCE;
    }

    public static synchronized void stopRunningInstance() throws Exception {
        if (INSTANCE != null) {
            INSTANCE.stop();
            INSTANCE = null;
        }
    }

    private void start(File root) throws BundleException, IOException {
        ChameleonConfiguration configuration = new ChameleonConfiguration(root);
        StringBuilder packages = new StringBuilder();
        Packages.junit(packages);
        Packages.wisdomtest(packages);
        Packages.javaxinject(packages);
        Packages.assertj(packages);
        Packages.osgihelpers(packages);
        configuration.put((Object)"org.osgi.framework.system.packages.extra", (Object)packages.toString());
        this.chameleon = new Chameleon(configuration);
        ChameleonExecutor.fixLoggingSystem(root);
        this.chameleon.start();
        Stability.waitForStability((BundleContext)this.chameleon.context());
    }

    public BundleContext context() {
        return this.chameleon.context();
    }

    private void stop() throws Exception {
        this.chameleon.stop();
    }

    public void deployProbe() throws BundleException {
        for (Bundle bundle : this.chameleon.context().getBundles()) {
            if (!bundle.getSymbolicName().equals("wisdom-probe-bundle")) continue;
            return;
        }
        try {
            Bundle probe = this.chameleon.context().installBundle("local", ProbeBundleMaker.probe());
            probe.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot install or start the probe bundle", e);
        }
    }

    public void deployApplication() throws BundleException {
        File application = new File(APPLICATION_BUNDLE);
        File base = new File(".");
        if (!application.isFile()) {
            try {
                BundlePackager.bundle((File)base, (File)application);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot build the application bundle", e);
            }
        }
        try {
            Bundle app = this.chameleon.context().installBundle(application.toURI().toURL().toExternalForm());
            app.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot install or start the application bundle", e);
        }
    }

    public InVivoRunner getInVivoRunnerInstance(Class<?> clazz) throws InitializationError, ClassNotFoundException, IOException {
        ServiceReference reference = this.context().getServiceReference(InVivoRunnerFactory.class);
        if (reference == null) {
            throw new IllegalStateException("Cannot retrieve the test probe from Wisdom");
        }
        InVivoRunnerFactory factory = (InVivoRunnerFactory)this.context().getService(reference);
        return factory.create(clazz.getName());
    }

    private static void fixLoggingSystem(File basedir) {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            Logger logbackLogger = lc.getLogger("ROOT");
            if (logbackLogger == null) {
                return;
            }
            Appender appender = logbackLogger.getAppender("FILE");
            if (appender instanceof RollingFileAppender) {
                RollingFileAppender fileAppender = (RollingFileAppender)appender;
                String file = new File(basedir, "logs/wisdom.log").getAbsolutePath();
                fileAppender.stop();
                FileUtils.deleteQuietly((File)new File("logs"));
                fileAppender.setFile(file);
                fileAppender.setContext((Context)lc);
                fileAppender.start();
            }
        }
    }
}

