/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.internals;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.test.internals.ClassPathResource;
import org.wisdom.test.probe.Activator;

public class ProbeBundleMaker {
    public static final String BUNDLE_NAME = "wisdom-probe-bundle";
    public static final String PACKAGES_TO_ADD = "org.wisdom.test.parents.*, org.wisdom.test.probe";
    public static final String PROBE_FILE = "target/osgi/probe.jar";
    public static final String TEST_CLASSES = "target/test-classes";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbeBundleMaker.class);

    private ProbeBundleMaker() {
    }

    public static InputStream probe() throws Exception {
        File probe = new File(PROBE_FILE);
        if (probe.isFile()) {
            return new FileInputStream(probe);
        }
        Properties properties = new Properties();
        ProbeBundleMaker.getProbeInstructions(properties);
        Builder builder = ProbeBundleMaker.getOSGiBuilder(properties, ProbeBundleMaker.computeClassPath());
        builder.build();
        ProbeBundleMaker.reportErrors("BND ~> ", builder.getWarnings(), builder.getErrors());
        File bnd = File.createTempFile("probe", ".jar");
        builder.getJar().write(bnd);
        Pojoization pojoization = new Pojoization();
        pojoization.pojoization(bnd, probe, new File("src/test/resources"));
        ProbeBundleMaker.reportErrors("iPOJO ~> ", pojoization.getWarnings(), pojoization.getErrors());
        return new FileInputStream(probe);
    }

    private static void getProbeInstructions(Properties properties) throws IOException {
        ArrayList<String> privates = new ArrayList<String>();
        ArrayList<String> exports = new ArrayList<String>();
        File tests = new File(TEST_CLASSES);
        LinkedHashSet packages = new LinkedHashSet();
        if (tests.isDirectory()) {
            Jar jar = new Jar(".", tests);
            packages.addAll(jar.getPackages());
            jar.close();
        }
        for (String s : packages) {
            if (s.endsWith("service") || s.endsWith("services")) {
                exports.add(s);
                continue;
            }
            if (s.isEmpty()) continue;
            privates.add(s + ";-split-package:=first");
        }
        properties.put("Private-Package", ProbeBundleMaker.toClause(privates) + "," + PACKAGES_TO_ADD);
        if (!exports.isEmpty()) {
            properties.put("Export-Package", ProbeBundleMaker.toClause(privates));
        }
        properties.put("Import-Package", "*;resolution:=optional");
        properties.put("bundle-symbolic-name", BUNDLE_NAME);
        properties.put("Bundle-Activator", Activator.class.getName());
    }

    private static String toClause(List<String> packages) {
        StringBuilder builder = new StringBuilder();
        for (String p : packages) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(p);
        }
        return builder.toString();
    }

    private static Jar[] computeClassPath() throws IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        File tests = new File(TEST_CLASSES);
        if (tests.isDirectory()) {
            list.add(new Jar(".", tests));
        }
        ClassPath classpath = ClassPath.from((ClassLoader)ProbeBundleMaker.class.getClassLoader());
        list.add(new JarFromClassloader(classpath));
        Jar[] cp = new Jar[list.size()];
        list.toArray(cp);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Builder getOSGiBuilder(Properties properties, Jar[] classpath) throws Exception {
        Builder builder = new Builder();
        Class<ProbeBundleMaker> clazz = ProbeBundleMaker.class;
        synchronized (ProbeBundleMaker.class) {
            builder.setBase(new File(""));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            builder.setProperties(ProbeBundleMaker.sanitize(properties));
            if (classpath != null) {
                builder.setClasspath(classpath);
            }
            return builder;
        }
    }

    protected static Properties sanitize(Properties properties) {
        Properties sanitizedEntries = new Properties();
        Iterator<Map.Entry<Object, Object>> itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            if (!(entry.getKey() instanceof String)) {
                String key = ProbeBundleMaker.sanitize(entry.getKey());
                if (!properties.containsKey(key)) {
                    sanitizedEntries.setProperty(key, ProbeBundleMaker.sanitize(entry.getValue()));
                }
                itr.remove();
                continue;
            }
            if (entry.getValue() instanceof String) continue;
            entry.setValue(ProbeBundleMaker.sanitize(entry.getValue()));
        }
        properties.putAll((Map<?, ?>)sanitizedEntries);
        return properties;
    }

    protected static String sanitize(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Iterable) {
            String delim = "";
            StringBuilder buf = new StringBuilder();
            for (Object i : (Iterable)value) {
                buf.append(delim).append(i);
                delim = ", ";
            }
            return buf.toString();
        }
        if (value.getClass().isArray()) {
            String delim = "";
            StringBuilder buf = new StringBuilder();
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                buf.append(delim).append(Array.get(value, i));
                delim = ", ";
            }
            return buf.toString();
        }
        return String.valueOf(value);
    }

    protected static boolean reportErrors(String prefix, List<String> warnings, List<String> errors) {
        for (String msg : warnings) {
            LOGGER.error(prefix + " : " + msg);
        }
        boolean hasErrors = false;
        String fileNotFound = "Input file does not exist: ";
        for (String msg : errors) {
            if (msg.startsWith(fileNotFound) && msg.endsWith("~")) {
                String duplicate = Processor.removeDuplicateMarker((String)msg.substring(fileNotFound.length()));
                System.err.println(prefix + " Duplicate path '" + duplicate + "' in Include-Resource");
                continue;
            }
            System.err.println(prefix + " : " + msg);
            hasErrors = true;
        }
        return hasErrors;
    }

    static {
        File probe = new File(PROBE_FILE);
        if (probe.isFile()) {
            FileUtils.deleteQuietly((File)probe);
        }
    }

    private static class JarFromClassloader
    extends Jar {
        public JarFromClassloader(ClassPath classpath) {
            super("classrealms");
            ClassPathResource.build(this, classpath, null);
        }
    }
}

