/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import org.assertj.core.api.Assertions;
import org.fluentlenium.adapter.FluentTest;
import org.fluentlenium.core.Fluent;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.testing.helpers.Stability;
import org.wisdom.api.engine.WisdomEngine;
import org.wisdom.test.WisdomBlackBoxRunner;
import org.wisdom.test.internals.ChameleonExecutor;

@RunWith(value=WisdomBlackBoxRunner.class)
public class WisdomFluentLeniumTest
extends FluentTest {
    public WebDriver webDriver = new HtmlUnitDriver();
    protected String hostname;
    protected int httpPort;

    @Before
    public void retrieveServerMetadata() throws Exception {
        if (this.hostname != null) {
            return;
        }
        Assertions.assertThat((Object)ChameleonExecutor.instance(null).context()).isNotNull();
        Stability.waitForStability((BundleContext)ChameleonExecutor.instance(null).context());
        ServiceReference reference = ChameleonExecutor.instance(null).context().getServiceReference(WisdomEngine.class.getName());
        Object engine = ChameleonExecutor.instance(null).context().getService(reference);
        this.hostname = (String)engine.getClass().getMethod("hostname", new Class[0]).invoke(engine, new Object[0]);
        this.httpPort = (Integer)engine.getClass().getMethod("httpPort", new Class[0]).invoke(engine, new Object[0]);
    }

    public String getHttpURl(String path) {
        String localUrl = path;
        if (localUrl.startsWith("http")) {
            return localUrl;
        }
        if (!localUrl.startsWith("/")) {
            localUrl = '/' + localUrl;
        }
        return "http://" + this.hostname + ":" + this.httpPort + localUrl;
    }

    public Fluent goTo(String url) {
        return super.goTo(this.getHttpURl(url));
    }
}

