/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.testing.helpers.OSGiHelper;
import org.wisdom.api.Controller;
import org.wisdom.api.router.Router;
import org.wisdom.api.templates.Template;
import org.wisdom.test.parents.Filter;
import org.wisdom.test.parents.Name;

public class DependencyInjector {
    private static final String INJECTION_ERROR = "Cannot inject a template in ";
    private static final String VALUE = "value";

    private DependencyInjector() {
    }

    public static void inject(Object object, OSGiHelper helper) {
        Field[] fields;
        for (Field field : fields = object.getClass().getFields()) {
            if (field.getAnnotation(Inject.class) == null) continue;
            DependencyInjector.inject(object, field, helper);
        }
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (field.getAnnotation(Inject.class) == null) continue;
            DependencyInjector.inject(object, field, helper);
        }
    }

    public static void inject(Object object, Field field, OSGiHelper helper) {
        if (field.getType().getName().equals(BundleContext.class.getName())) {
            DependencyInjector.set(object, field, helper.getContext());
        } else if (field.getType().getName().equals(Template.class.getName())) {
            Object template;
            String name = DependencyInjector.readNameAnnotation(field);
            String filter = DependencyInjector.readFilterAnnotation(field);
            if (name == null && filter == null) {
                throw new ExceptionInInitializerError(INJECTION_ERROR + field.getName() + ", " + "the @Name annotation or @Filter annotation are required to indicate the template to inject");
            }
            if (name != null && filter != null) {
                throw new ExceptionInInitializerError(INJECTION_ERROR + field.getName() + ", " + "both @Name annotation and @Filter annotations are used to indicate the template to " + "inject, please use only one");
            }
            if (name != null) {
                template = DependencyInjector.waitForService(helper, Template.class, "(name=" + name + ")");
                if (template == null) {
                    throw new ExceptionInInitializerError(INJECTION_ERROR + field.getName() + ", " + "cannot find a template with name=" + name);
                }
                DependencyInjector.set(object, field, template);
            }
            if (filter != null) {
                template = DependencyInjector.waitForService(helper, Template.class, filter);
                if (template == null) {
                    throw new ExceptionInInitializerError(INJECTION_ERROR + field.getName() + ", " + "cannot find a template matching the given filter: " + filter);
                }
                DependencyInjector.set(object, field, template);
            }
        } else if (field.getType().getName().equals(Router.class.getName())) {
            Object router = DependencyInjector.waitForService(helper, Router.class, null);
            DependencyInjector.set(object, field, router);
        } else if (DependencyInjector.isController(field.getType())) {
            String filter = String.format("(factory.name=%s)", field.getType().getName());
            Object controller = DependencyInjector.waitForService(helper, Controller.class, filter);
            if (controller == null) {
                throw new ExceptionInInitializerError("Cannot inject a controller in '" + field.getName() + "' - " + "cannot find a controller matching the given filter: " + filter);
            }
            DependencyInjector.set(object, field, controller);
        } else {
            String filter = DependencyInjector.readFilterAnnotation(field);
            Object service = DependencyInjector.waitForService(helper, field.getType(), filter);
            if (service == null) {
                throw new ExceptionInInitializerError("Cannot inject a service in " + field.getName() + ", " + "cannot find a service publishing " + field.getType().getName() + " matching the filter " + filter);
            }
            DependencyInjector.set(object, field, service);
        }
    }

    private static boolean isController(Class<?> type) {
        List<String> classes = DependencyInjector.traverseHierarchy(type);
        return classes.contains(Controller.class.getName());
    }

    private static List<String> traverseHierarchy(Class<?> type) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(type.getName());
        for (Class<?> clazz : type.getInterfaces()) {
            list.addAll(DependencyInjector.traverseHierarchy(clazz));
        }
        if (type.getSuperclass() != null) {
            list.addAll(DependencyInjector.traverseHierarchy(type.getSuperclass()));
        }
        return list;
    }

    private static String readNameAnnotation(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!annotation.annotationType().getName().endsWith(Name.class.getName())) continue;
            try {
                Method method = annotation.getClass().getMethod(VALUE, new Class[0]);
                return (String)method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError("Cannot retrieve the value of the @Name annotation");
            }
        }
        return null;
    }

    private static String readFilterAnnotation(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!annotation.annotationType().getName().endsWith(Filter.class.getName())) continue;
            try {
                Method method = annotation.getClass().getMethod(VALUE, new Class[0]);
                return (String)method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError("Cannot retrieve the value of the @Filter annotation");
            }
        }
        return null;
    }

    private static void set(Object object, Field field, Object value) {
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error when injecting " + value + " in " + field, e);
        }
    }

    private static Object waitForService(OSGiHelper helper, Class<?> clazz, String filter) {
        ServiceReference ref = helper.waitForService(clazz.getName(), filter, 10000L, false);
        if (ref == null) {
            return null;
        }
        return helper.getServiceObject(ref);
    }
}

