/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.http;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.jsoup.nodes.Document;
import org.wisdom.test.http.Callback;
import org.wisdom.test.http.HttpClientHelper;
import org.wisdom.test.http.HttpRequest;
import org.wisdom.test.http.HttpResponse;

public abstract class BaseRequest {
    protected static final String UTF_8 = "UTF-8";
    protected HttpRequest httpRequest;

    protected BaseRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    protected BaseRequest() {
    }

    public HttpResponse<String> asString() throws Exception {
        return HttpClientHelper.request(this.httpRequest, String.class);
    }

    public Future<HttpResponse<String>> asStringAsync() {
        return HttpClientHelper.requestAsync(this.httpRequest, String.class, null);
    }

    public Future<HttpResponse<String>> asStringAsync(Callback<String> callback) {
        return HttpClientHelper.requestAsync(this.httpRequest, String.class, callback);
    }

    public HttpResponse<JsonNode> asJson() throws Exception {
        return HttpClientHelper.request(this.httpRequest, JsonNode.class);
    }

    public HttpResponse<Document> asHtml() throws Exception {
        return HttpClientHelper.request(this.httpRequest, Document.class);
    }

    public Future<HttpResponse<JsonNode>> asJsonAsync() {
        return HttpClientHelper.requestAsync(this.httpRequest, JsonNode.class, null);
    }

    public Future<HttpResponse<JsonNode>> asJsonAsync(Callback<JsonNode> callback) {
        return HttpClientHelper.requestAsync(this.httpRequest, JsonNode.class, callback);
    }

    public HttpResponse<InputStream> asBinary() throws Exception {
        return HttpClientHelper.request(this.httpRequest, InputStream.class);
    }

    public Future<HttpResponse<InputStream>> asBinaryAsync() {
        return HttpClientHelper.requestAsync(this.httpRequest, InputStream.class, null);
    }

    public Future<HttpResponse<InputStream>> asBinaryAsync(Callback<InputStream> callback) {
        return HttpClientHelper.requestAsync(this.httpRequest, InputStream.class, callback);
    }
}

