/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.internals;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class ClassPathResource
implements Resource {
    private final ClassPath.ResourceInfo resource;
    private String extra;
    private long modified = System.currentTimeMillis();

    public ClassPathResource(ClassPath.ResourceInfo resource) {
        this.resource = resource;
    }

    public InputStream openInputStream() throws IOException {
        return this.resource.url().openStream();
    }

    public static void build(Jar jar, ClassPath classpath, Pattern doNotCopy) {
        ImmutableSet resources = classpath.getResources();
        for (ClassPath.ResourceInfo resource : resources) {
            if (doNotCopy != null && doNotCopy.matcher(resource.getResourceName()).matches()) continue;
            jar.putResource(resource.getResourceName(), (Resource)new ClassPathResource(resource));
        }
    }

    public String toString() {
        return ":" + this.resource.getResourceName() + ":";
    }

    public void write(OutputStream out) throws Exception {
        InputStream input = this.openInputStream();
        try {
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public long lastModified() {
        return this.modified;
    }

    public String getExtra() {
        return this.extra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() throws Exception {
        InputStream stream = this.resource.url().openStream();
        try {
            long l = IOUtils.toByteArray((InputStream)stream).length;
            return l;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

