/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test;

import java.io.File;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.test.internals.ChameleonExecutor;
import org.wisdom.test.internals.RunnerUtils;

public class WisdomBlackBoxRunner
extends BlockJUnit4ClassRunner
implements Filterable,
Sortable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomBlackBoxRunner.class);

    public WisdomBlackBoxRunner(Class<?> klass) throws Exception {
        super(klass);
        File basedir = RunnerUtils.checkWisdomInstallation();
        File bundle = RunnerUtils.detectApplicationBundleIfExist(new File(basedir, "application"));
        if (bundle != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the application directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            LOGGER.debug("Deleting ? : " + bundle.delete());
        }
        if ((bundle = RunnerUtils.detectApplicationBundleIfExist(new File(basedir, "runtime"))) != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the runtime directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            LOGGER.debug("Deleting ? : " + bundle.delete());
        }
        System.setProperty("application.configuration", new File(basedir, "/conf/application.conf").getAbsolutePath());
        ChameleonExecutor executor = ChameleonExecutor.instance(basedir);
        executor.deployApplication();
    }

    public void sort(Sorter sorter) {
        super.sort(sorter);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        super.filter(filter);
    }
}

