/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.cookie.Cookie;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.wisdom.test.http.ClientFactory;

public class HttpResponse<T> {
    private int code;
    private Map<String, String> headers;
    private InputStream rawBody;
    private T body;

    public HttpResponse(org.apache.http.HttpResponse response, Class<T> responseClass) {
        HttpEntity responseEntity = response.getEntity();
        Header[] allHeaders = response.getAllHeaders();
        this.headers = new HashMap<String, String>();
        for (Header header : allHeaders) {
            this.headers.put(header.getName().toLowerCase(), header.getValue());
        }
        this.code = response.getStatusLine().getStatusCode();
        this.parseResponseBody(responseClass, responseEntity);
    }

    private void parseResponseBody(Class<T> responseClass, HttpEntity responseEntity) {
        block8: {
            if (responseEntity != null) {
                try {
                    InputStream responseInputStream = responseEntity.getContent();
                    if (this.isGzipped()) {
                        responseInputStream = new GZIPInputStream(responseEntity.getContent());
                    }
                    byte[] raw = HttpResponse.getBytes(responseInputStream);
                    this.rawBody = new ByteArrayInputStream(raw);
                    if (JsonNode.class.equals(responseClass)) {
                        String jsonString = new String(raw, Charsets.UTF_8).trim();
                        this.body = new ObjectMapper().readValue(jsonString, JsonNode.class);
                        break block8;
                    }
                    if (Document.class.equals(responseClass)) {
                        String r = new String(raw, Charsets.UTF_8).trim();
                        this.body = Jsoup.parse((String)r);
                        break block8;
                    }
                    if (String.class.equals(responseClass)) {
                        this.body = responseEntity.getContentEncoding() != null && responseEntity.getContentEncoding().getValue() != null ? new String(raw, responseEntity.getContentEncoding().getValue()) : new String(raw, Charsets.UTF_8);
                        break block8;
                    }
                    if (InputStream.class.equals(responseClass)) {
                        this.body = this.rawBody;
                        break block8;
                    }
                    throw new IllegalArgumentException("Unknown result type. Only String, JsonNode, Document and InputStream are supported.");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    private boolean isGzipped() {
        Set<Map.Entry<String, String>> heads = this.headers.entrySet();
        for (Map.Entry<String, String> header : heads) {
            if (!"content-encoding".equalsIgnoreCase(header.getKey()) || !"gzip".equalsIgnoreCase(header.getValue())) continue;
            return true;
        }
        return false;
    }

    private static byte[] getBytes(InputStream is) throws IOException {
        return IOUtils.toByteArray((InputStream)is);
    }

    public int code() {
        return this.code;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public InputStream raw() {
        return this.rawBody;
    }

    public T body() {
        return this.body;
    }

    public String contentType() {
        String type = this.headers.get("Content-Type".toLowerCase());
        if (type != null && type.contains(";")) {
            return type.substring(0, type.indexOf(";")).trim();
        }
        return type;
    }

    public String charset() {
        String type = this.headers.get("Content-Type".toLowerCase());
        if (type != null && type.contains("charset=")) {
            return type.substring(type.indexOf("charset=") + 8).trim();
        }
        return null;
    }

    public int length() {
        String length = this.headers.get("Content-Length".toLowerCase());
        if (length == null) {
            return -1;
        }
        return Integer.parseInt(length);
    }

    public String header(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public Cookie cookie(String name) {
        List<Cookie> cookies = ClientFactory.getCookies();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }
}

