/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.internals;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class RunnerUtils {
    public static File detectApplicationBundleIfExist(File directory) throws IOException {
        String version;
        String strippedVersion;
        Properties properties = RunnerUtils.getMavenProperties();
        if (properties == null || directory == null || !directory.isDirectory()) {
            return null;
        }
        String artifactId = properties.getProperty("project.artifactId");
        String groupId = properties.getProperty("project.groupId");
        final String bsn = RunnerUtils.getBundleSymbolicName(groupId, artifactId);
        Iterator files = FileUtils.iterateFiles((File)directory, (IOFileFilter)new AbstractFileFilter(strippedVersion = (version = properties.getProperty("project.version")).endsWith("-SNAPSHOT") ? version.substring(0, version.length() - "-SNAPSHOT".length()) : version){
            final /* synthetic */ String val$strippedVersion;
            {
                this.val$strippedVersion = string2;
            }

            public boolean accept(File file) {
                return file.isFile() && file.getName().startsWith(bsn + "-" + this.val$strippedVersion) && file.getName().endsWith(".jar");
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (files.hasNext()) {
            return (File)files.next();
        }
        return null;
    }

    public static File getApplicationArtifactIfExists(File chameleonRoot) throws IOException {
        Properties properties = RunnerUtils.getMavenProperties();
        if (properties == null || chameleonRoot == null || !chameleonRoot.isDirectory()) {
            return null;
        }
        String artifactId = properties.getProperty("project.artifactId");
        String version = properties.getProperty("project.version");
        File artifact = new File(chameleonRoot.getParentFile(), artifactId + "-" + version + ".jar");
        if (artifact.isFile()) {
            return artifact;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getMavenProperties() throws IOException {
        File osgi = new File("target/osgi/osgi.properties");
        if (osgi.isFile()) {
            Properties properties;
            FileInputStream fis = null;
            try {
                Properties read = new Properties();
                fis = new FileInputStream(osgi);
                read.load(fis);
                properties = read;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return properties;
        }
        return null;
    }

    public static File checkWisdomInstallation() {
        File directory = new File("target/wisdom");
        if (!directory.isDirectory()) {
            throw new ExceptionInInitializerError("Wisdom is not installed in " + directory.getAbsolutePath() + " - " + "please check your execution directory, and that Wisdom is prepared correctly. To setup Wisdom, " + "run 'mvn pre-integration-test' from your application directory");
        }
        File conf = new File(directory, "conf/application.conf");
        if (!conf.isFile()) {
            throw new ExceptionInInitializerError("Wisdom is not correctly installed in " + directory.getAbsolutePath() + " - the configuration file does not exist. Please check your Wisdom runtime. To setup Wisdom, " + "run 'mvn clean pre-integration-test' from your application directory");
        }
        return directory;
    }

    public static String getBundleFileName() throws IOException {
        Properties properties = RunnerUtils.getMavenProperties();
        String artifactId = properties.getProperty("project.artifactId");
        String groupId = properties.getProperty("project.groupId");
        String bsn = RunnerUtils.getBundleSymbolicName(groupId, artifactId);
        String version = properties.getProperty("project.version");
        return bsn + "-" + version + ".jar";
    }

    public static String getBundleSymbolicName(String groupId, String artifactId) {
        String lastSection;
        int i = groupId.lastIndexOf(46);
        if (artifactId.equals(lastSection = groupId.substring(++i))) {
            return groupId;
        }
        if (artifactId.equals(groupId) || artifactId.startsWith(groupId + ".")) {
            return artifactId;
        }
        if (artifactId.startsWith(lastSection) && !Character.isLetterOrDigit((artifactId = artifactId.substring(lastSection.length())).charAt(0))) {
            return (groupId + "." + artifactId.substring(1)).replace("-", ".");
        }
        return (groupId + "." + artifactId).replace("-", ".");
    }
}

