/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.wisdom.api.http.FileItem;
import org.wisdom.api.http.Status;
import org.wisdom.test.parents.Action;
import org.wisdom.test.parents.FakeFileItem;

public class WisdomUnitTest
implements Status {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String JSON_ERROR = "Cannot retrieve the json form of result `";

    public static FileItem from(File file) {
        return new FakeFileItem(file, null);
    }

    public static FileItem from(File file, String field) {
        return new FakeFileItem(file, field);
    }

    public int status(Action.ActionResult result) {
        return result.getResult().getStatusCode();
    }

    public String contentType(Action.ActionResult result) {
        return result.getResult().getContentType();
    }

    public ObjectNode json(Action.ActionResult result) {
        try {
            return (ObjectNode)MAPPER.valueToTree(result.getResult().getRenderable().content());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(JSON_ERROR + result + "`", e);
        }
    }

    public ArrayNode jsonarray(Action.ActionResult result) {
        try {
            return (ArrayNode)MAPPER.valueToTree(result.getResult().getRenderable().content());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(JSON_ERROR + result + "`", e);
        }
    }

    public String toString(Action.ActionResult result) {
        try {
            return result.getResult().getRenderable().content().toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot retrieve the String form of result", e);
        }
    }

    public byte[] toBytes(Action.ActionResult result) {
        try {
            return IOUtils.toByteArray((InputStream)result.getResult().getRenderable().render(result.getContext(), result.getResult()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot retrieve the byte[] form of result `" + result + "`", e);
        }
    }
}

