/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.internals;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.runners.model.InitializationError;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.core.Chameleon;
import org.ow2.chameleon.core.ChameleonConfiguration;
import org.ow2.chameleon.testing.helpers.Stability;
import org.ow2.chameleon.testing.helpers.TimeUtils;
import org.slf4j.LoggerFactory;
import org.wisdom.maven.utils.BundlePackager;
import org.wisdom.maven.utils.ChameleonInstanceHolder;
import org.wisdom.test.internals.Packages;
import org.wisdom.test.internals.ProbeBundleMaker;
import org.wisdom.test.internals.RunnerUtils;
import org.wisdom.test.shared.InVivoRunner;
import org.wisdom.test.shared.InVivoRunnerFactory;

public final class ChameleonExecutor {
    private static final String APPLICATION_BUNDLE = "target/osgi/application.jar";
    private static ChameleonExecutor INSTANCE;
    private File root;

    private ChameleonExecutor() {
    }

    public static synchronized ChameleonExecutor instance(File root) throws BundleException, IOException {
        if (INSTANCE == null) {
            File application = new File(APPLICATION_BUNDLE);
            if (application.isFile()) {
                FileUtils.deleteQuietly((File)application);
            }
            INSTANCE = new ChameleonExecutor();
            ChameleonExecutor.INSTANCE.root = root;
            INSTANCE.start(root);
        }
        return INSTANCE;
    }

    public static synchronized void stopRunningInstance() throws Exception {
        if (INSTANCE != null) {
            INSTANCE.stop();
            ChameleonInstanceHolder.set(null);
            INSTANCE = null;
        }
    }

    private void start(File root) throws BundleException, IOException {
        ChameleonConfiguration configuration = new ChameleonConfiguration(root);
        configuration.put((Object)"org.osgi.framework.storage", (Object)(root.getAbsolutePath() + "/chameleon-test-cache"));
        StringBuilder packages = new StringBuilder();
        Packages.junit(packages);
        Packages.wisdomtest(packages);
        Packages.javaxinject(packages);
        Packages.assertj(packages);
        Packages.osgihelpers(packages);
        configuration.put((Object)"org.osgi.framework.system.packages.extra", (Object)packages.toString());
        String port = System.getProperty("http.port");
        if (port == null) {
            System.setProperty("http.port", "0");
        }
        Chameleon chameleon = new Chameleon(configuration);
        ChameleonInstanceHolder.fixLoggingSystem((File)root);
        chameleon.start();
        String factor = System.getProperty("TIME_FACTOR");
        if (factor != null) {
            LoggerFactory.getLogger(this.getClass()).info("Setting TIME_FACTOR to " + factor);
            TimeUtils.TIME_FACTOR = Integer.valueOf(factor);
        }
        Stability.waitForStability((BundleContext)chameleon.context());
        ChameleonInstanceHolder.set((Chameleon)chameleon);
    }

    public BundleContext context() {
        return ChameleonInstanceHolder.get().context();
    }

    private void stop() throws Exception {
        File original = RunnerUtils.getApplicationArtifactIfExists(this.root);
        ChameleonInstanceHolder.get().stop();
        if (original != null) {
            String fileName = RunnerUtils.getBundleFileName();
            File out = new File(new File(this.root, "application"), fileName);
            FileUtils.copyFile((File)original, (File)out, (boolean)true);
        }
    }

    public void deployProbe() throws BundleException {
        for (Bundle bundle : ChameleonInstanceHolder.get().context().getBundles()) {
            if (!bundle.getSymbolicName().equals("wisdom-probe-bundle")) continue;
            return;
        }
        try {
            Bundle probe = ChameleonInstanceHolder.get().context().installBundle("local", ProbeBundleMaker.probe());
            probe.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot install or start the probe bundle", e);
        }
    }

    public void deployApplication() throws BundleException {
        File application = new File(APPLICATION_BUNDLE);
        File base = new File(".");
        if (!application.isFile()) {
            try {
                BundlePackager.bundle((File)base, (File)application, (BundlePackager.Reporter)new BundlePackager.Reporter(){

                    public void error(String msg) {
                        LoggerFactory.getLogger((String)"Bundle Packager").error(msg);
                    }

                    public void warn(String msg) {
                        LoggerFactory.getLogger((String)"Bundle Packager").warn(msg);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot build the application bundle", e);
            }
        }
        try {
            Bundle app = ChameleonInstanceHolder.get().context().installBundle(application.toURI().toURL().toExternalForm());
            app.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot install or start the application bundle", e);
        }
    }

    public InVivoRunner getInVivoRunnerInstance(Class<?> clazz) throws InitializationError, ClassNotFoundException, IOException {
        ServiceReference reference = this.context().getServiceReference(InVivoRunnerFactory.class);
        if (reference == null) {
            throw new IllegalStateException("Cannot retrieve the test probe from Wisdom");
        }
        InVivoRunnerFactory factory = (InVivoRunnerFactory)this.context().getService(reference);
        return factory.create(clazz.getName());
    }
}

