/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.Cookies;
import org.wisdom.api.cookies.FlashCookie;
import org.wisdom.api.cookies.SessionCookie;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.FileItem;
import org.wisdom.api.http.Request;
import org.wisdom.api.router.Route;
import org.wisdom.test.parents.FakeCookies;
import org.wisdom.test.parents.FakeFileItem;
import org.wisdom.test.parents.FakeFlashCookie;
import org.wisdom.test.parents.FakeRequest;
import org.wisdom.test.parents.FakeSessionCookie;

public class FakeContext
implements Context {
    private static AtomicLong counter = new AtomicLong();
    private Long id;
    private Map<String, List<String>> form = Maps.newHashMap();
    private Map<String, List<String>> parameters = Maps.newHashMap();
    private SessionCookie session = new FakeSessionCookie();
    private FlashCookie flash = new FakeFlashCookie();
    private Object body;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String path;
    private FakeCookies cookies = new FakeCookies();
    private HashMap<String, FileItem> files = new HashMap();
    private FakeRequest request = new FakeRequest(this);

    public FakeContext() {
        this.id = counter.getAndIncrement();
    }

    public Long id() {
        return this.id;
    }

    public Request request() {
        return this.request;
    }

    public String path() {
        return this.path;
    }

    public FlashCookie flash() {
        return this.flash;
    }

    public SessionCookie session() {
        return this.session;
    }

    public Cookie cookie(String cookieName) {
        return this.cookies.get(cookieName);
    }

    public boolean hasCookie(String cookieName) {
        return this.cookies.get(cookieName) != null;
    }

    public Cookies cookies() {
        return this.cookies;
    }

    public FakeContext setCookie(String name, String value) {
        this.cookies.add(name, value);
        return this;
    }

    public FakeContext setCookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public String contextPath() {
        return null;
    }

    public String parameter(String name) {
        if (this.parameters.get(name) != null) {
            return this.parameters.get(name).get(0);
        }
        return null;
    }

    public List<String> parameterMultipleValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    public String parameter(String name, String defaultValue) {
        String v = this.parameter(name);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public Integer parameterAsInteger(String name) {
        String v = this.parameter(name);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return null;
    }

    public Integer parameterAsInteger(String name, Integer defaultValue) {
        String v = this.parameter(name);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return defaultValue;
    }

    public Boolean parameterAsBoolean(String name) {
        String v = this.parameter(name);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return null;
    }

    public Boolean parameterAsBoolean(String name, boolean defaultValue) {
        String v = this.parameter(name);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return defaultValue;
    }

    public String parameterFromPath(String name) {
        return this.parameter(name);
    }

    public String parameterFromPathEncoded(String name) {
        return this.parameter(name);
    }

    public Integer parameterFromPathAsInteger(String name) {
        return this.parameterAsInteger(name);
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String header(String name) {
        List<String> v = this.headers.get(name);
        if (v != null && !v.isEmpty()) {
            return v.get(0);
        }
        return null;
    }

    public List<String> headers(String name) {
        if (this.headers.containsKey(name)) {
            return this.headers.get(name);
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String cookieValue(String name) {
        Cookie cookie = this.cookie(name);
        if (cookie != null) {
            return cookie.value();
        }
        return null;
    }

    public <T> T body(Class<T> classOfT) {
        return (T)this.body;
    }

    public String body() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public BufferedReader reader() throws IOException {
        String body = this.body();
        if (body != null) {
            return new BufferedReader(new StringReader(body));
        }
        return null;
    }

    public Route route() {
        return null;
    }

    public void route(Route route) {
    }

    public FakeContext setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean isMultipart() {
        return !this.form.isEmpty() || !this.files.isEmpty();
    }

    public Collection<? extends FileItem> files() {
        return this.files.values();
    }

    public FileItem file(String name) {
        return this.files.get(name);
    }

    @Deprecated
    public Map<String, List<String>> attributes() {
        return this.form();
    }

    public Map<String, List<String>> form() {
        return this.form;
    }

    @Deprecated
    public FakeContext setAttribute(String name, String value) {
        return this.setFormField(name, value);
    }

    public FakeContext setFormField(String name, String value) {
        List<String> values = this.form.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.form.put(name, values);
        }
        values.add(value);
        return this;
    }

    public FakeContext setParameter(String name, String value) {
        ArrayList list = Lists.newArrayList();
        list.add(value);
        this.setParameter(name, list);
        return this;
    }

    public FakeContext setParameter(String name, List<String> values) {
        this.parameters.put(name, values);
        return this;
    }

    public FakeContext setBody(Object body) {
        this.body = body;
        return this;
    }

    public FakeContext setHeader(String name, String value) {
        List<String> list = this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(name, list);
        }
        list.add(value);
        return this;
    }

    public FakeContext setHeader(String name, String ... values) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(values));
        this.headers.put(name, list);
        return this;
    }

    @Deprecated
    public FakeContext setAttribute(String name, File file) {
        return this.setFormField(name, file);
    }

    public FakeContext setFormField(String name, File file) {
        this.files.put(name, new FakeFileItem(file, name));
        return this;
    }

    public FakeContext addToSession(String key, String value) {
        this.session.put(key, value);
        return this;
    }

    public FakeContext addToFlash(String key, String value) {
        this.flash.put(key, value);
        return this;
    }
}

