/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.testing.helpers.OSGiHelper;
import org.ow2.chameleon.testing.helpers.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stability {
    private static final Logger LOGGER = LoggerFactory.getLogger(Stability.class);
    public static final int MAX_TRIES = 500;

    public static void waitForStability(BundleContext context) throws IllegalStateException {
        Stability.waitForBundleStability(context);
        Stability.waitForIPOJOQueuesToBeEmpty(context);
        Stability.waitForServiceStability(context);
    }

    private static void waitForIPOJOQueuesToBeEmpty(BundleContext context) {
        int count = 0;
        try {
            Collection refs = context.getServiceReferences(QueueService.class, null);
            ArrayList<Object> queues = new ArrayList<Object>();
            for (ServiceReference ref : refs) {
                queues.add(context.getService(ref));
            }
            boolean emptyness = false;
            while (!emptyness && count < 500) {
                emptyness = Stability.areAllQueuesEmpty(queues);
                if (!emptyness) {
                    TimeUtils.grace((int)500);
                }
                ++count;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (count == 500) {
            LOGGER.error("iPOJO processing queues are not empty after 500 tries");
            throw new IllegalStateException("Cannot reach the service stability");
        }
    }

    private static boolean areAllQueuesEmpty(List<Object> queues) {
        boolean empty = true;
        for (Object q : queues) {
            try {
                Method currents = q.getClass().getMethod("getCurrents", new Class[0]);
                Method waiters = q.getClass().getMethod("getWaiters", new Class[0]);
                int cur = (Integer)currents.invoke(q, new Object[0]);
                int wai = (Integer)waiters.invoke(q, new Object[0]);
                LOGGER.debug("queue: " + q + " #current : " + cur + " / #waiting : " + wai);
                empty = empty && cur == 0 && wai == 0;
            }
            catch (Exception e) {
                LOGGER.error("Cannot analyze queue's metrics for {}", q, (Object)e);
                throw new IllegalArgumentException("Cannot analyze queue's metrics", e);
            }
        }
        return empty;
    }

    private static void waitForServiceStability(BundleContext context) {
        int count;
        boolean serviceStability = false;
        int count1 = 0;
        int count2 = 0;
        for (count = 0; !serviceStability && count < 500; ++count) {
            try {
                ServiceReference[] refs = context.getServiceReferences((String)null, null);
                count1 = refs.length;
                TimeUtils.grace((int)500);
                refs = context.getServiceReferences((String)null, null);
                count2 = refs.length;
                serviceStability = count1 == count2;
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("An exception was thrown while checking the service stability", (Throwable)e);
                serviceStability = false;
            }
        }
        if (count == 500) {
            System.err.println("Service stability isn't reached after 500 tries (" + count1 + " != " + count2);
            throw new IllegalStateException("Cannot reach the service stability");
        }
    }

    public static void waitForBundleStability(BundleContext context) {
        int count;
        boolean bundleStability = Stability.getBundleStability(context);
        for (count = 0; !bundleStability && count < 500; ++count) {
            try {
                Thread.sleep(100 * TimeUtils.TIME_FACTOR);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bundleStability = Stability.getBundleStability(context);
        }
        if (count == 500) {
            LOGGER.error("Bundle stability isn't reached after 500 tries");
            for (Bundle bundle : context.getBundles()) {
                LOGGER.error("Bundle " + bundle.getBundleId() + " - " + bundle.getSymbolicName() + " -> " + bundle.getState());
            }
            throw new IllegalStateException("Cannot reach the bundle stability");
        }
    }

    public static boolean getBundleStability(BundleContext bc) {
        Bundle[] bundles;
        boolean stability = true;
        for (Bundle bundle : bundles = bc.getBundles()) {
            stability = OSGiHelper.isFragment((Bundle)bundle) ? stability && bundle.getState() == 4 : stability && bundle.getState() == 32;
        }
        return stability;
    }
}

