/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import org.assertj.core.api.Assertions;
import org.fluentlenium.adapter.FluentTest;
import org.fluentlenium.core.Fluent;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.engine.WisdomEngine;
import org.wisdom.test.WisdomBlackBoxRunner;
import org.wisdom.test.internals.ChameleonExecutor;
import org.wisdom.test.parents.Stability;

@RunWith(value=WisdomBlackBoxRunner.class)
public class WisdomFluentLeniumTest
extends FluentTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomFluentLeniumTest.class);
    protected String hostname;
    protected int httpPort;

    @Before
    public void retrieveServerMetadata() throws Exception {
        if (this.hostname != null) {
            return;
        }
        Assertions.assertThat((Object)ChameleonExecutor.instance(null).context()).isNotNull();
        Stability.waitForStability(ChameleonExecutor.instance(null).context());
        ServiceReference reference = ChameleonExecutor.instance(null).context().getServiceReference(WisdomEngine.class.getName());
        Object engine = ChameleonExecutor.instance(null).context().getService(reference);
        this.hostname = (String)engine.getClass().getMethod("hostname", new Class[0]).invoke(engine, new Object[0]);
        this.httpPort = (Integer)engine.getClass().getMethod("httpPort", new Class[0]).invoke(engine, new Object[0]);
    }

    public String getHttpURl(String path) {
        String localUrl = path;
        if (localUrl.startsWith("http")) {
            return localUrl;
        }
        if (!localUrl.startsWith("/")) {
            localUrl = '/' + localUrl;
        }
        return "http://" + this.hostname + ":" + this.httpPort + localUrl;
    }

    public WebDriver getDefaultDriver() {
        String browser = System.getProperty("fluentlenium.browser");
        LOGGER.debug("Selecting Selenium Browser using " + browser);
        if (browser == null) {
            LOGGER.debug("Using default HTML Unit Driver");
            return new HtmlUnitDriver();
        }
        if ("chrome".equalsIgnoreCase(browser)) {
            LOGGER.debug("Using Chrome");
            return new ChromeDriver();
        }
        if ("firefox".equalsIgnoreCase(browser)) {
            LOGGER.debug("Using Firefox");
            return new FirefoxDriver();
        }
        if ("ie".equalsIgnoreCase(browser) || "internetexplorer".equalsIgnoreCase(browser)) {
            LOGGER.debug("Using Internet Explorer");
            return new InternetExplorerDriver();
        }
        if ("safari".equalsIgnoreCase(browser)) {
            LOGGER.debug("Using Safari");
            return new SafariDriver();
        }
        throw new IllegalArgumentException("Unknown browser : " + browser);
    }

    public Fluent goTo(String url) {
        return super.goTo(this.getHttpURl(url));
    }
}

