/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test;

import java.io.File;
import java.lang.reflect.Method;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.test.internals.ChameleonExecutor;
import org.wisdom.test.internals.RunnerUtils;
import org.wisdom.test.parents.Stability;
import org.wisdom.test.parents.WisdomBlackBoxTest;

public class WisdomBlackBoxRunner
extends BlockJUnit4ClassRunner
implements Filterable,
Sortable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomBlackBoxRunner.class);
    private final Bundle probe;

    public WisdomBlackBoxRunner(Class<?> klass) throws Exception {
        super(klass);
        File basedir = RunnerUtils.checkWisdomInstallation();
        File bundle = RunnerUtils.detectApplicationBundleIfExist(new File(basedir, "application"));
        if (bundle != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the application directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            LOGGER.debug("Deleting ? : " + bundle.delete());
        }
        if ((bundle = RunnerUtils.detectApplicationBundleIfExist(new File(basedir, "runtime"))) != null && bundle.exists()) {
            LOGGER.info("Application bundle found in the runtime directory (" + bundle.getAbsoluteFile() + "), " + "the bundle will be deleted and replaced by the tested bundle (with the very same content).");
            LOGGER.debug("Deleting ? : " + bundle.delete());
        }
        System.setProperty("application.configuration", new File(basedir, "/conf/application.conf").getAbsolutePath());
        ChameleonExecutor executor = ChameleonExecutor.instance(basedir);
        executor.deployApplication();
        if (this.mustDeployTheTestBundle(klass)) {
            LOGGER.info("Deploying test bundle");
            this.probe = executor.deployProbe();
            Stability.waitForStability(executor.context());
        } else {
            this.probe = null;
        }
    }

    private boolean mustDeployTheTestBundle(Class<?> klass) {
        if (WisdomBlackBoxTest.class.isAssignableFrom(klass)) {
            LOGGER.debug("Checking whether or not the test bundle must be deployed");
            try {
                Object test = klass.newInstance();
                Method method = klass.getMethod("deployTestBundle", new Class[0]);
                return (Boolean)method.invoke(test, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot invoke the 'deployTestBundle' method to determine whether or not the test bundle must be deployed.", (Throwable)e);
            }
        }
        return false;
    }

    public void sort(Sorter sorter) {
        super.sort(sorter);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        super.filter(filter);
    }

    protected Statement withAfterClasses(final Statement statement) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    if (statement != null) {
                        statement.evaluate();
                    }
                }
                finally {
                    if (WisdomBlackBoxRunner.this.probe != null) {
                        try {
                            LOGGER.info("Uninstalling probe bundle");
                            WisdomBlackBoxRunner.this.probe.uninstall();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to uninstall the probe bundle", (Throwable)e);
                        }
                    }
                }
            }
        };
    }
}

