/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import java.nio.charset.Charset;
import org.assertj.core.api.AbstractAssert;
import org.wisdom.test.assertions.ContextAssert;
import org.wisdom.test.assertions.SessionCookieAssert;
import org.wisdom.test.assertions.StatusAssert;
import org.wisdom.test.parents.Action;

public class ActionResultAssert
extends AbstractAssert<ActionResultAssert, Action.ActionResult> {
    protected ActionResultAssert(Action.ActionResult actual) {
        super((Object)actual, ActionResultAssert.class);
    }

    public static ActionResultAssert assertThat(Action.ActionResult actual) {
        return new ActionResultAssert(actual);
    }

    public StatusAssert status() {
        this.isNotNull();
        return StatusAssert.assertThat(((Action.ActionResult)this.actual).getResult().getStatusCode());
    }

    public ActionResultAssert hasStatus(Integer statusCode) {
        this.isNotNull();
        if (((Action.ActionResult)this.actual).getResult().getStatusCode() != statusCode.intValue()) {
            this.failWithMessage("Expected status to be <%s> but was <%s>", new Object[]{statusCode, ((Action.ActionResult)this.actual).getResult().getStatusCode()});
        }
        return this;
    }

    public ActionResultAssert hasContentType(String contentType) {
        this.isNotNull();
        if (!((Action.ActionResult)this.actual).getResult().getContentType().equals(contentType)) {
            this.failWithMessage("Expected content type to be <%s> but was <%s>", new Object[]{contentType, ((Action.ActionResult)this.actual).getResult().getContentType()});
        }
        return this;
    }

    public ActionResultAssert hasFullContentType(String fullContentType) {
        this.isNotNull();
        if (!((Action.ActionResult)this.actual).getResult().getFullContentType().equals(fullContentType)) {
            this.failWithMessage("Expected content type to be <%s> but was <%s>", new Object[]{fullContentType, ((Action.ActionResult)this.actual).getResult().getFullContentType()});
        }
        return this;
    }

    public ActionResultAssert hasCharset(Charset charset) {
        this.isNotNull();
        if (!((Action.ActionResult)this.actual).getResult().getCharset().equals(charset)) {
            this.failWithMessage("Expected charset to be <%s> but was <%s>", new Object[]{charset.displayName(), ((Action.ActionResult)this.actual).getResult().getCharset().displayName()});
        }
        return this;
    }

    public ActionResultAssert hasInSession(String key, String value) {
        this.isNotNull();
        SessionCookieAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).containsEntry(key, value);
        return this;
    }

    public ActionResultAssert hasSessionId(String id) {
        this.isNotNull();
        SessionCookieAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).hasId(id);
        return this;
    }

    public ActionResultAssert sessionIsEmpty() {
        this.isNotNull();
        SessionCookieAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).isEmpty();
        return this;
    }

    public ActionResultAssert sessionIsNotEmpty() {
        this.isNotNull();
        SessionCookieAssert.assertThat(((Action.ActionResult)this.actual).getContext().session()).isNotEmpty();
        return this;
    }

    public <T> ActionResultAssert hasBody(Class<T> klass, T body) {
        this.isNotNull();
        ContextAssert.assertThat(((Action.ActionResult)this.actual).getContext()).hasBody(klass, body);
        return this;
    }

    public ActionResultAssert hasBody(String body) {
        this.isNotNull();
        ContextAssert.assertThat(((Action.ActionResult)this.actual).getContext()).hasBody(body);
        return this;
    }

    public ActionResultAssert hasInBody(String inBody) {
        this.isNotNull();
        ContextAssert.assertThat(((Action.ActionResult)this.actual).getContext()).hasInBody(inBody);
        return this;
    }

    public ActionResultAssert hasBodyMatch(String regex) {
        this.isNotNull();
        ContextAssert.assertThat(((Action.ActionResult)this.actual).getContext()).hasBodyMatch(regex);
        return this;
    }

    public ActionResultAssert hasContextId(Long id) {
        this.isNotNull();
        ContextAssert.assertThat(((Action.ActionResult)this.actual).getContext()).hasId(id);
        return this;
    }

    public ActionResultAssert contextIsMultipart() {
        this.isNotNull();
        ContextAssert.assertThat(((Action.ActionResult)this.actual).getContext()).isMultipart();
        return this;
    }

    public ActionResultAssert contextIsNotMultipart() {
        this.isNotNull();
        ContextAssert.assertThat(((Action.ActionResult)this.actual).getContext()).isNotMultipart();
        return this;
    }

    public ActionResultAssert isNotNull() {
        super.isNotNull();
        if (((Action.ActionResult)this.actual).getResult() == null) {
            this.failWithMessage("Result should not be null", new Object[0]);
        }
        return this;
    }
}

