/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import org.assertj.core.api.AbstractAssert;
import org.wisdom.api.http.Context;
import org.wisdom.test.assertions.SessionCookieAssert;

public class ContextAssert
extends AbstractAssert<ContextAssert, Context> {
    protected ContextAssert(Context actual) {
        super((Object)actual, ContextAssert.class);
    }

    public static ContextAssert assertThat(Context actual) {
        return new ContextAssert(actual);
    }

    public ContextAssert hasInSession(String key, String value) {
        this.isNotNull();
        SessionCookieAssert.assertThat(((Context)this.actual).session()).containsEntry(key, value);
        return this;
    }

    public ContextAssert hasId(Long id) {
        this.isNotNull();
        if (!((Context)this.actual).id().equals(id)) {
            this.failWithMessage("Expected id to be <%s> but was <%s>", new Object[]{id, ((Context)this.actual).id()});
        }
        return this;
    }

    public ContextAssert isMultipart() {
        this.isNotNull();
        if (!((Context)this.actual).isMultipart()) {
            this.failWithMessage("Expected to be multi-part", new Object[0]);
        }
        return this;
    }

    public ContextAssert isNotMultipart() {
        this.isNotNull();
        if (((Context)this.actual).isMultipart()) {
            this.failWithMessage("Expected NOT to be multi-part", new Object[0]);
        }
        return this;
    }

    public ContextAssert hasContextPath(String path) {
        this.isNotNull();
        if (!((Context)this.actual).contextPath().equals(path)) {
            this.failWithMessage("Expected body to be <%n%s%n> but was <%n%s%n>", new Object[]{path, ((Context)this.actual).contextPath()});
        }
        return this;
    }

    public ContextAssert hasInBody(String inBody) {
        this.isNotNull();
        if (!((Context)this.actual).body().contains(inBody)) {
            this.failWithMessage("Expected body to contain <%s> but body is <%s>", new Object[]{inBody, ((Context)this.actual).body()});
        }
        return this;
    }

    public ContextAssert hasBodyMatch(String regex) {
        this.isNotNull();
        if (!((Context)this.actual).body().matches(regex)) {
            this.failWithMessage("Expected body to match <%s> but body is <%s>", new Object[]{regex, ((Context)this.actual).body()});
        }
        return this;
    }

    public ContextAssert hasBody(String body) {
        this.isNotNull();
        if (!((Context)this.actual).body().equals(body)) {
            this.failWithMessage("Expected body to be <%s> but was <%s>", new Object[]{body, ((Context)this.actual).body()});
        }
        return this;
    }

    public <T> ContextAssert hasBody(Class<T> klass, T body) {
        this.isNotNull();
        if (!((Context)this.actual).body(klass).equals(body)) {
            this.failWithMessage("Expected body to be <%s> but was <%s>", new Object[]{body.toString(), ((Context)this.actual).body(klass).toString()});
        }
        return this;
    }
}

