/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import org.assertj.core.api.AbstractAssert;
import org.wisdom.test.http.HttpResponse;

public class HttpResponseAssert<T>
extends AbstractAssert<HttpResponseAssert<T>, HttpResponse<T>> {
    protected HttpResponseAssert(HttpResponse<T> actual) {
        super(actual, HttpResponseAssert.class);
    }

    public static <T> HttpResponseAssert<T> assertThat(HttpResponse<T> actual) {
        return new HttpResponseAssert<T>(actual);
    }

    public HttpResponseAssert<T> hasInHeader(String key, String value) {
        this.isNotNull();
        if (!value.equals(((HttpResponse)this.actual).headers().get(key))) {
            this.failWithMessage("Expected header to contain entry <%s, %s> but value was <%s>", new Object[]{key, value, String.valueOf(((HttpResponse)this.actual).headers().get(key))});
        }
        return this;
    }

    public HttpResponseAssert<T> hasCookie(String cookieName) {
        this.isNotNull();
        if (((HttpResponse)this.actual).cookie(cookieName) == null) {
            this.failWithMessage("Expected to contain a cookie with name <%s>", new Object[]{cookieName});
        }
        return this;
    }

    public HttpResponseAssert<T> hasContentType(String contentType) {
        this.isNotNull();
        if (!((HttpResponse)this.actual).contentType().equals(contentType)) {
            this.failWithMessage("Expected content type to be <%s> but was <%s>", new Object[]{contentType, ((HttpResponse)this.actual).contentType()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasCode(int code) {
        this.isNotNull();
        if (code != ((HttpResponse)this.actual).code()) {
            this.failWithMessage("Expected status code to be <%n> but was <%n>", new Object[]{code, ((HttpResponse)this.actual).code()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasInBody(String inBody) {
        this.isNotNull();
        if (!(((HttpResponse)this.actual).body() instanceof String)) {
            this.failWithMessage("Body is not an instance of String, body is <%s>", new Object[]{((HttpResponse)this.actual).body().toString()});
        }
        if (!((String)((HttpResponse)this.actual).body()).contains(inBody)) {
            this.failWithMessage("Expected body to contain <%s>, but body is <%s>", new Object[]{inBody, ((HttpResponse)this.actual).body().toString()});
        }
        return this;
    }

    public HttpResponseAssert<T> bodyMatches(String regex) {
        this.isNotNull();
        if (!(((HttpResponse)this.actual).body() instanceof String)) {
            this.failWithMessage("Body is not an instance of String, body is <%s>", new Object[]{((HttpResponse)this.actual).body().toString()});
        }
        if (!((String)((HttpResponse)this.actual).body()).matches(regex)) {
            this.failWithMessage("Expected body to match <%s>, but body is <%s>", new Object[]{regex, ((HttpResponse)this.actual).body().toString()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasBody(T body) {
        this.isNotNull();
        if (!body.equals(((HttpResponse)this.actual).body())) {
            this.failWithMessage("Expected body to be <%s> but was <%s>", new Object[]{body.toString(), ((HttpResponse)this.actual).body().toString()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasLength(Integer length) {
        this.isNotNull();
        if (((HttpResponse)this.actual).length() != length.intValue()) {
            this.failWithMessage("Expected length to be <%s> but was <%s>", new Object[]{length, ((HttpResponse)this.actual).length()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasCharset(String charset) {
        this.isNotNull();
        if (!((HttpResponse)this.actual).charset().equals(charset)) {
            this.failWithMessage("Expected charset to be <%s> but was <%s>", new Object[]{charset, ((HttpResponse)this.actual).charset()});
        }
        return this;
    }
}

