/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import org.assertj.core.api.AbstractAssert;
import org.wisdom.api.cookies.SessionCookie;

public class SessionCookieAssert
extends AbstractAssert<SessionCookieAssert, SessionCookie> {
    protected SessionCookieAssert(SessionCookie actual) {
        super((Object)actual, SessionCookieAssert.class);
    }

    public static SessionCookieAssert assertThat(SessionCookie actual) {
        return new SessionCookieAssert(actual);
    }

    public SessionCookieAssert isEmpty() {
        this.isNotNull();
        if (!((SessionCookie)this.actual).isEmpty()) {
            this.failWithMessage("Expected session to be empty", new Object[0]);
        }
        return this;
    }

    public SessionCookieAssert isNotEmpty() {
        this.isNotNull();
        if (((SessionCookie)this.actual).isEmpty()) {
            this.failWithMessage("Expected session not to be empty", new Object[0]);
        }
        return this;
    }

    public SessionCookieAssert hasId(String id) {
        this.isNotNull();
        if (!((SessionCookie)this.actual).getId().equals(id)) {
            this.failWithMessage("Expected id to be <%s> but was <%s>", new Object[]{id, ((SessionCookie)this.actual).getId()});
        }
        return this;
    }

    public SessionCookieAssert containsEntry(String key, String value) {
        this.isNotNull();
        this.isNotEmpty();
        if (!value.equals(((SessionCookie)this.actual).get(key))) {
            this.failWithMessage("Expected session to contain entry <%s, %s> but value was <%s>", new Object[]{key, value, String.valueOf(((SessionCookie)this.actual).get(key))});
        }
        return this;
    }
}

