/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.http;

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.test.http.BaseRequest;
import org.wisdom.test.http.Body;

public class HttpRequest
extends BaseRequest {
    private HttpMethod httpMethod;
    protected String url;
    private Map<String, String> headers = new HashMap<String, String>();
    protected Body body;

    public HttpRequest(HttpMethod method, String url) {
        this.httpMethod = method;
        try {
            this.url = this.parseUrl(url).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.httpRequest = this;
    }

    private URL parseUrl(String s) throws Exception {
        return new URI(s.replaceAll("\\s+", "%20")).toURL();
    }

    public HttpRequest basicAuth(String username, String password) {
        String key = username + ":" + password;
        String encoded = new String(Base64.encodeBase64((byte[])key.getBytes(Charset.forName("UTF-8"))), Charset.forName("UTF-8"));
        this.header("Authorization", "Basic " + encoded);
        return this;
    }

    public HttpRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequest headers(Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.headers);
    }

    public Body getBody() {
        return this.body;
    }
}

