/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import org.junit.Before;
import org.junit.runner.RunWith;
import org.wisdom.api.http.HeaderNames;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Status;
import org.wisdom.maven.utils.ChameleonInstanceHolder;
import org.wisdom.test.WisdomBlackBoxRunner;
import org.wisdom.test.http.GetRequest;
import org.wisdom.test.http.HttpRequestWithBody;

@RunWith(value=WisdomBlackBoxRunner.class)
public class WisdomBlackBoxTest
implements HeaderNames,
Status {
    private String hostname;
    private int httpPort;
    private int httpsPort;

    @Before
    public void retrieveServerMetadata() throws Exception {
        if (this.hostname != null) {
            return;
        }
        this.hostname = ChameleonInstanceHolder.getHostName();
        this.httpPort = ChameleonInstanceHolder.getHttpPort();
        this.httpsPort = ChameleonInstanceHolder.getHttpsPort();
    }

    public boolean deployTestBundle() {
        return false;
    }

    public String getHttpURl(String path) {
        String localUrl = path;
        if (localUrl.startsWith("http")) {
            return localUrl;
        }
        if (!localUrl.startsWith("/")) {
            localUrl = '/' + localUrl;
        }
        return "http://" + this.hostname + ":" + this.httpPort + localUrl;
    }

    public String getHttpsURl(String path) {
        String localUrl = path;
        if (localUrl.startsWith("https")) {
            return localUrl;
        }
        if (!localUrl.startsWith("/")) {
            localUrl = '/' + localUrl;
        }
        return "https://" + this.hostname + ":" + this.httpsPort + localUrl;
    }

    public GetRequest get(String url) {
        return new GetRequest(HttpMethod.GET, this.getHttpURl(url));
    }

    public HttpRequestWithBody post(String url) {
        return new HttpRequestWithBody(HttpMethod.POST, this.getHttpURl(url));
    }

    public HttpRequestWithBody delete(String url) {
        return new HttpRequestWithBody(HttpMethod.DELETE, this.getHttpURl(url));
    }

    public HttpRequestWithBody put(String url) {
        return new HttpRequestWithBody(HttpMethod.PUT, this.getHttpURl(url));
    }
}

