/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import org.assertj.core.api.AbstractAssert;
import org.wisdom.api.http.Context;
import org.wisdom.test.assertions.SessionAssert;

public class ContextAssert
extends AbstractAssert<ContextAssert, Context> {
    protected ContextAssert(Context actual) {
        super((Object)actual, ContextAssert.class);
    }

    public static ContextAssert assertThat(Context actual) {
        return new ContextAssert(actual);
    }

    public ContextAssert hasParameter(String key, String value) {
        this.isNotNull();
        if (((Context)this.actual).parameter(key) == null) {
            this.failWithMessage("Expected to have parameter <%s>", new Object[]{key});
        }
        if (!((Context)this.actual).parameter(key).equals(value)) {
            this.failWithMessage("Expected to have parameter <%s> set to <%s> but was <%s>", new Object[]{key, value, ((Context)this.actual).parameter(key)});
        }
        return this;
    }

    public ContextAssert hasInSession(String key, String value) {
        this.isNotNull();
        SessionAssert.assertThat(((Context)this.actual).session()).containsEntry(key, value);
        return this;
    }

    public ContextAssert isMultipart() {
        this.isNotNull();
        if (!((Context)this.actual).isMultipart()) {
            this.failWithMessage("Expected to be multipart", new Object[0]);
        }
        return this;
    }

    public ContextAssert isNotMultipart() {
        this.isNotNull();
        if (((Context)this.actual).isMultipart()) {
            this.failWithMessage("Expected NOT to be multipart", new Object[0]);
        }
        return this;
    }

    public ContextAssert hasInBody(String inBody) {
        this.isNotNull();
        if (!((Context)this.actual).body().contains(inBody)) {
            this.failWithMessage("Expected body to contain <%s> but body is <%s>", new Object[]{inBody, ((Context)this.actual).body()});
        }
        return this;
    }

    public ContextAssert hasBodyMatch(String regex) {
        this.isNotNull();
        if (!((Context)this.actual).body().matches(regex)) {
            this.failWithMessage("Expected body to match <%s> but body is <%s>", new Object[]{regex, ((Context)this.actual).body()});
        }
        return this;
    }

    public ContextAssert hasBody(String body) {
        this.isNotNull();
        if (!((Context)this.actual).body().equals(body)) {
            this.failWithMessage("Expected body to be <%s> but was <%s>", new Object[]{body, ((Context)this.actual).body()});
        }
        return this;
    }

    public <T> ContextAssert hasBody(Class<T> klass, T body) {
        this.isNotNull();
        if (!((Context)this.actual).body(klass).equals(body)) {
            this.failWithMessage("Expected body to be <%s> but was <%s>", new Object[]{body.toString(), ((Context)this.actual).body(klass).toString()});
        }
        return this;
    }
}

