/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.assertions;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.Charset;
import org.assertj.core.api.AbstractAssert;
import org.wisdom.test.http.HttpResponse;

public class HttpResponseAssert<T>
extends AbstractAssert<HttpResponseAssert<T>, HttpResponse<T>> {
    protected HttpResponseAssert(HttpResponse<T> actual) {
        super(actual, HttpResponseAssert.class);
    }

    public static <T> HttpResponseAssert<T> assertThat(HttpResponse<T> actual) {
        return new HttpResponseAssert<T>(actual);
    }

    public HttpResponseAssert<T> hasHeader(String key, String value) {
        ((HttpResponseAssert)this.isNotNull()).hasHeader(key);
        if (!value.equals(((HttpResponse)this.actual).headers().get(key))) {
            this.failWithMessage("Expected header to contain entry <%s, %s> but value was <%s>", new Object[]{key, value, String.valueOf(((HttpResponse)this.actual).headers().get(key))});
        }
        return this;
    }

    public HttpResponseAssert<T> hasHeader(String key) {
        this.isNotNull();
        if (((HttpResponse)this.actual).headers().get(key) == null) {
            this.failWithMessage("Expected headers to contain key <%s>", new Object[]{key});
        }
        return this;
    }

    public HttpResponseAssert<T> hasCookie(String cookieName) {
        this.isNotNull();
        if (((HttpResponse)this.actual).cookie(cookieName) == null) {
            this.failWithMessage("Expected to contain a cookie with name <%s>", new Object[]{cookieName});
        }
        return this;
    }

    public HttpResponseAssert<T> hasCookie(String cookieName, String value) {
        ((HttpResponseAssert)this.isNotNull()).hasCookie(cookieName);
        if (!((HttpResponse)this.actual).cookie(cookieName).getValue().equalsIgnoreCase(value)) {
            this.failWithMessage("Expected to contain a cookie with name <%s> and with value <%s> but the contained value was <%s>", new Object[]{cookieName, value, ((HttpResponse)this.actual).cookie(cookieName).getValue()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasContentType(String contentType) {
        this.isNotNull();
        if (!((HttpResponse)this.actual).contentType().equals(contentType)) {
            this.failWithMessage("Expected content type to be <%s> but was <%s>", new Object[]{contentType, ((HttpResponse)this.actual).contentType()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasInBody(String inBody) {
        this.isNotNull();
        if (!(((HttpResponse)this.actual).body() instanceof String)) {
            this.failWithMessage("Body is not an instance of String, body is <%s>", new Object[]{((HttpResponse)this.actual).body().toString()});
        }
        if (!((String)((HttpResponse)this.actual).body()).contains(inBody)) {
            this.failWithMessage("Expected body to contain <%s>, but body is <%s>", new Object[]{inBody, ((HttpResponse)this.actual).body().toString()});
        }
        return this;
    }

    public HttpResponseAssert<T> bodyMatches(String regex) {
        this.isNotNull();
        if (!(((HttpResponse)this.actual).body() instanceof String)) {
            this.failWithMessage("Body is not an instance of String, body is <%s>", new Object[]{((HttpResponse)this.actual).body().toString()});
        }
        if (!((String)((HttpResponse)this.actual).body()).matches(regex)) {
            this.failWithMessage("Expected body to match <%s>, but body is <%s>", new Object[]{regex, ((HttpResponse)this.actual).body().toString()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasBody(T body) {
        this.isNotNull();
        if (!body.equals(((HttpResponse)this.actual).body())) {
            this.failWithMessage("Expected body to be <%s> but was <%s>", new Object[]{body.toString(), ((HttpResponse)this.actual).body().toString()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasLength(int length) {
        this.isNotNull();
        if (((HttpResponse)this.actual).length() != length) {
            this.failWithMessage("Expected length to be <%s> but was <%s>", new Object[]{length, ((HttpResponse)this.actual).length()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasCharset(Charset charset) {
        this.isNotNull();
        if (!((HttpResponse)this.actual).charset().equals(charset.toString())) {
            this.failWithMessage("Expected charset to be <%s> but was <%s>", new Object[]{charset, ((HttpResponse)this.actual).charset()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasHeaders() {
        this.isNotNull();
        if (((HttpResponse)this.actual).headers().isEmpty()) {
            this.failWithMessage("Expected headers to be not empty", new Object[0]);
        }
        return this;
    }

    public HttpResponseAssert<T> hasBody() {
        this.isNotNull();
        if (((HttpResponse)this.actual).body() == null) {
            this.failWithMessage("Expected content to be not null", new Object[0]);
        }
        if (((HttpResponse)this.actual).body().toString().length() == 0) {
            this.failWithMessage("Expected content to be not empty", new Object[0]);
        }
        return this;
    }

    public HttpResponseAssert<T> hasStatus(int status) {
        this.isNotNull();
        if (status != ((HttpResponse)this.actual).code()) {
            this.failWithMessage("Expected status code to be <%s> but was <%s>", new Object[]{status, ((HttpResponse)this.actual).code()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasJsonTextField(String path, String value) {
        this.isNotNull();
        this.isJson();
        JsonNode node = ((JsonNode)((HttpResponse)this.actual).body()).at(path);
        if (node.isMissingNode()) {
            this.failWithMessage("Expected node pointed by <%s> to be present in <%s>", new Object[]{path, ((HttpResponse)this.actual).body().toString()});
        }
        if (!node.isTextual()) {
            this.failWithMessage("Expected node pointed by <%s> to be textual", new Object[]{path});
        }
        if (!node.asText().equals(value)) {
            this.failWithMessage("Expected node pointed by <%s> to be <%s> but was <%s>", new Object[]{path, value, node.asText()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasJsonTextFieldContaining(String path, String ... values) {
        this.isNotNull();
        this.isJson();
        JsonNode node = ((JsonNode)((HttpResponse)this.actual).body()).at(path);
        if (node.isMissingNode()) {
            this.failWithMessage("Expected node pointed by <%s> to be present in <%s>", new Object[]{path, ((HttpResponse)this.actual).body().toString()});
        }
        if (!node.isTextual()) {
            this.failWithMessage("Expected node pointed by <%s> to be textual", new Object[]{path});
        }
        String s = node.asText();
        for (String v : values) {
            if (s.contains(v)) continue;
            this.failWithMessage("Expected node pointed by <%s> to contain <%s>", new Object[]{path, v});
        }
        return this;
    }

    public HttpResponseAssert<T> hasJsonNumericField(String path, int value) {
        this.isNotNull();
        this.isJson();
        JsonNode node = ((JsonNode)((HttpResponse)this.actual).body()).at(path);
        if (node.isMissingNode()) {
            this.failWithMessage("Expected node pointed by <%s> to be present in <%s>", new Object[]{path, ((HttpResponse)this.actual).body().toString()});
        }
        if (node.asInt() != value) {
            this.failWithMessage("Expected node pointed by <%s> to be <%s> but was <%s>", new Object[]{path, value, node.asInt()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasJsonNumericField(String path, long value) {
        this.isNotNull();
        this.isJson();
        JsonNode node = ((JsonNode)((HttpResponse)this.actual).body()).at(path);
        if (node.isMissingNode()) {
            this.failWithMessage("Expected node pointed by <%s> to be present in <%s>", new Object[]{path, ((HttpResponse)this.actual).body().toString()});
        }
        if (node.asLong() != value) {
            this.failWithMessage("Expected node pointed by <%s> to be <%s> but was <%s>", new Object[]{path, value, node.asLong()});
        }
        return this;
    }

    public HttpResponseAssert<T> hasJsonNumericField(String path, double value) {
        this.isNotNull();
        this.isJson();
        JsonNode node = ((JsonNode)((HttpResponse)this.actual).body()).at(path);
        if (node.isMissingNode()) {
            this.failWithMessage("Expected node pointed by <%s> to be present in <%s>", new Object[]{path, ((HttpResponse)this.actual).body().toString()});
        }
        if (node.asDouble() != value) {
            this.failWithMessage("Expected node pointed by <%s> to be <%s> but was <%s>", new Object[]{path, value, node.asDouble()});
        }
        return this;
    }

    public HttpResponseAssert<T> isJson() {
        return ((HttpResponseAssert)this.isNotNull()).hasContentType("application/json");
    }
}

