/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.http;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.ow2.chameleon.testing.helpers.TimeUtils;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.test.http.Callback;
import org.wisdom.test.http.ClientFactory;
import org.wisdom.test.http.HttpDeleteWithBody;
import org.wisdom.test.http.HttpRequest;
import org.wisdom.test.http.HttpResponse;
import org.wisdom.test.http.Options;

public final class HttpClientHelper {
    private static final String USER_AGENT = "wisdom-test/1.1";

    private HttpClientHelper() {
    }

    private static <T> FutureCallback<org.apache.http.HttpResponse> prepareCallback(final Class<T> responseClass, final Callback<T> callback) {
        if (callback == null) {
            return null;
        }
        return new FutureCallback<org.apache.http.HttpResponse>(){

            public void cancelled() {
                callback.cancelled();
            }

            public void completed(org.apache.http.HttpResponse arg0) {
                callback.completed(new HttpResponse(arg0, responseClass));
            }

            public void failed(Exception arg0) {
                callback.failed(arg0);
            }
        };
    }

    public static <T> Future<HttpResponse<T>> requestAsync(HttpRequest request, final Class<T> responseClass, Callback<T> callback) {
        HttpRequestBase requestObj = HttpClientHelper.prepareRequest(request);
        CloseableHttpAsyncClient asyncHttpClient = ClientFactory.getAsyncHttpClient();
        if (!asyncHttpClient.isRunning()) {
            asyncHttpClient.start();
        }
        final Future future = asyncHttpClient.execute((HttpUriRequest)requestObj, HttpClientHelper.prepareCallback(responseClass, callback));
        return new Future<HttpResponse<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public HttpResponse<T> get() throws InterruptedException, ExecutionException {
                org.apache.http.HttpResponse httpResponse = (org.apache.http.HttpResponse)future.get();
                return new HttpResponse(httpResponse, responseClass);
            }

            @Override
            public HttpResponse<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                org.apache.http.HttpResponse httpResponse = (org.apache.http.HttpResponse)future.get(timeout * (long)TimeUtils.TIME_FACTOR, unit);
                return new HttpResponse(httpResponse, responseClass);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> HttpResponse<T> request(HttpRequest request, Class<T> responseClass) throws Exception {
        HttpRequestBase requestObj = HttpClientHelper.prepareRequest(request);
        HttpClient client = ClientFactory.getHttpClient();
        try {
            org.apache.http.HttpResponse response = client.execute((HttpUriRequest)requestObj);
            HttpResponse<T> httpResponse = new HttpResponse<T>(response, responseClass);
            requestObj.releaseConnection();
            HttpResponse<T> httpResponse2 = httpResponse;
            return httpResponse2;
        }
        finally {
            requestObj.releaseConnection();
        }
    }

    private static HttpRequestBase prepareRequest(HttpRequest request) {
        request.header("user-agent", USER_AGENT);
        request.header("accept-encoding", "gzip");
        Object defaultHeaders = Options.getOption(Options.Option.DEFAULT_HEADERS);
        if (defaultHeaders != null) {
            Set entrySet = ((Map)defaultHeaders).entrySet();
            for (Map.Entry entry : entrySet) {
                request.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Object reqObj = null;
        switch (request.getHttpMethod()) {
            case GET: {
                reqObj = new HttpGet(request.getUrl());
                break;
            }
            case POST: {
                reqObj = new HttpPost(request.getUrl());
                break;
            }
            case PUT: {
                reqObj = new HttpPut(request.getUrl());
                break;
            }
            case DELETE: {
                reqObj = new HttpDeleteWithBody(request.getUrl());
                break;
            }
            case OPTIONS: {
                reqObj = new HttpOptions(request.getUrl());
                break;
            }
        }
        if (reqObj == null) {
            throw new IllegalStateException("Cannot build the request - unsupported HTTP verb : " + request.getHttpMethod());
        }
        for (Map.Entry<Object, Object> entry : request.getHeaders().entrySet()) {
            reqObj.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (request.getHttpMethod() != HttpMethod.GET && request.getBody() != null && reqObj instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)reqObj).setEntity(request.getBody().getEntity());
        }
        return reqObj;
    }
}

