/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.shared;

import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.osgi.framework.BundleContext;
import org.ow2.chameleon.core.services.Stability;
import org.ow2.chameleon.testing.helpers.OSGiHelper;
import org.ow2.chameleon.testing.helpers.TimeUtils;
import org.wisdom.test.parents.DependencyInjector;

public class InVivoRunner
extends BlockJUnit4ClassRunner {
    private final OSGiHelper helper;

    public InVivoRunner(BundleContext context, Class<?> klass) throws InitializationError {
        super(klass);
        TimeUtils.TIME_FACTOR = Integer.getInteger("TIME_FACTOR", 1);
        if (TimeUtils.TIME_FACTOR == 1) {
            TimeUtils.TIME_FACTOR = Integer.getInteger("time.factor", 1);
        }
        this.helper = new OSGiHelper(context);
    }

    public Object createTest() throws Exception {
        Stability stability = (Stability)this.helper.getServiceObject(Stability.class);
        if (stability == null) {
            throw new IllegalStateException("Cannot compute stability - Stability service missing");
        }
        if (!stability.waitForStability()) {
            throw new IllegalStateException("Cannot reach stability");
        }
        Object object = super.createTest();
        DependencyInjector.inject(object, this.helper);
        return object;
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        this.helper.dispose();
    }
}

