/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.http;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.wisdom.test.http.BaseRequest;
import org.wisdom.test.http.Body;
import org.wisdom.test.http.HttpRequest;

public class MultipartBody
extends BaseRequest
implements Body {
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private boolean hasFile;
    private HttpRequest httpRequestObj;

    public MultipartBody(HttpRequest httpRequest) {
        super(httpRequest);
        this.httpRequestObj = httpRequest;
    }

    public MultipartBody field(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public MultipartBody field(String name, File file) {
        this.parameters.put(name, file);
        this.hasFile = true;
        return this;
    }

    public MultipartBody basicAuth(String username, String password) {
        this.httpRequestObj.basicAuth(username, password);
        return this;
    }

    @Override
    public HttpEntity getEntity() {
        if (this.hasFile) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (Map.Entry<String, Object> part : this.parameters.entrySet()) {
                if (part.getValue() instanceof File) {
                    this.hasFile = true;
                    builder.addPart(part.getKey(), (ContentBody)new FileBody((File)part.getValue()));
                    continue;
                }
                builder.addPart(part.getKey(), (ContentBody)new StringBody(part.getValue().toString(), ContentType.APPLICATION_FORM_URLENCODED));
            }
            return builder.build();
        }
        try {
            return new UrlEncodedFormEntity(MultipartBody.getList(this.parameters), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<NameValuePair> getList(Map<String, Object> parameters) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                result.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
        }
        return result;
    }
}

