/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.internals;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.felix.ipojo.manipulator.util.IsolatedClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.maven.osgi.BundlePackager;
import org.wisdom.maven.osgi.ProjectScanner;
import org.wisdom.test.internals.ClassPathResource;
import org.wisdom.test.probe.Activator;

public class ProbeBundleMaker {
    public static final String BUNDLE_NAME = "wisdom-probe-bundle";
    public static final String PACKAGES_TO_ADD = "org.wisdom.test.parents.*, org.wisdom.test.probe, org.wisdom.test.assertions, org.ow2.chameleon.testing.helpers,org.ow2.chameleon.testing.helpers.constants";
    public static final String PROBE_FILE = "target/osgi/probe.jar";
    public static final String TEST_CLASSES = "target/test-classes";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbeBundleMaker.class);

    private ProbeBundleMaker() {
    }

    public static InputStream probe() throws Exception {
        File probe = new File(PROBE_FILE);
        if (probe.isFile()) {
            return new FileInputStream(probe);
        }
        Properties maven = BundlePackager.readMavenProperties((File)new File("."));
        Properties instructions = new Properties();
        ProbeBundleMaker.getProbeInstructions(instructions, maven);
        Builder builder = ProbeBundleMaker.getOSGiBuilder(instructions, ProbeBundleMaker.computeClassPath());
        builder.build();
        ProbeBundleMaker.reportErrors("BND ~> ", builder.getWarnings(), builder.getErrors());
        File bnd = File.createTempFile("probe", ".jar");
        builder.getJar().write(bnd);
        IsolatedClassLoader classLoader = new IsolatedClassLoader(ProbeBundleMaker.class.getClassLoader(), true);
        File tests = new File(TEST_CLASSES);
        classLoader.addURL(tests.toURI().toURL());
        Pojoization pojoization = new Pojoization();
        pojoization.pojoization(bnd, probe, new File("src/test/resources"), (ClassLoader)classLoader);
        ProbeBundleMaker.reportErrors("iPOJO ~> ", pojoization.getWarnings(), pojoization.getErrors());
        return new FileInputStream(probe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void getProbeInstructions(Properties instructions, Properties maven) throws IOException {
        ProjectScanner scanner;
        ArrayList<String> privates = new ArrayList<String>();
        ArrayList<String> exports = new ArrayList<String>();
        File basedir = new File(maven.getProperty("project.baseDir"));
        String resources = BundlePackager.getLocalResources((File)basedir, (boolean)true, (ProjectScanner)(scanner = new ProjectScanner(basedir)));
        if (!resources.isEmpty()) {
            instructions.put("Include-Resource", resources);
        }
        Set packages = scanner.getPackagesFromTestSources();
        for (String s : packages) {
            if (s.endsWith("service") || s.endsWith("services")) {
                exports.add(s);
                continue;
            }
            if (s.isEmpty()) continue;
            privates.add(s + ";-split-package:=first");
        }
        instructions.put("Private-Package", ProbeBundleMaker.toClause(privates) + "," + PACKAGES_TO_ADD);
        if (!exports.isEmpty()) {
            instructions.put("Export-Package", ProbeBundleMaker.toClause(privates));
        }
        instructions.put("Import-Package", "org.osgi.framework;version=1.7, *;resolution:=optional");
        instructions.put("bundle-symbolic-name", BUNDLE_NAME);
        instructions.put("Bundle-Activator", Activator.class.getName());
        FileOutputStream fos = null;
        try {
            File out = new File("target/osgi/probe-instructions.properties");
            fos = new FileOutputStream(out);
            instructions.store(fos, "BND Instructions for test probe");
        }
        catch (IOException e) {
            IOUtils.closeQuietly(fos);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static String toClause(List<String> packages) {
        StringBuilder builder = new StringBuilder();
        for (String p : packages) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(p);
        }
        return builder.toString();
    }

    private static Jar[] computeClassPath() throws IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        File tests = new File(TEST_CLASSES);
        if (tests.isDirectory()) {
            list.add(new Jar(".", tests));
        }
        ClassPath classpath = ClassPath.from((ClassLoader)ProbeBundleMaker.class.getClassLoader());
        list.add(new JarFromClassloader(classpath));
        Jar[] cp = new Jar[list.size()];
        list.toArray(cp);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Builder getOSGiBuilder(Properties properties, Jar[] classpath) throws Exception {
        Builder builder = new Builder();
        Class<ProbeBundleMaker> clazz = ProbeBundleMaker.class;
        synchronized (ProbeBundleMaker.class) {
            builder.setBase(new File(""));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            builder.setProperties(ProbeBundleMaker.sanitize(properties));
            if (classpath != null) {
                builder.setClasspath(classpath);
            }
            return builder;
        }
    }

    protected static Properties sanitize(Properties properties) {
        Properties sanitizedEntries = new Properties();
        Iterator<Map.Entry<Object, Object>> itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            if (!(entry.getKey() instanceof String)) {
                String key = ProbeBundleMaker.sanitize(entry.getKey());
                if (!properties.containsKey(key)) {
                    sanitizedEntries.setProperty(key, ProbeBundleMaker.sanitize(entry.getValue()));
                }
                itr.remove();
                continue;
            }
            if (entry.getValue() instanceof String) continue;
            entry.setValue(ProbeBundleMaker.sanitize(entry.getValue()));
        }
        properties.putAll((Map<?, ?>)sanitizedEntries);
        return properties;
    }

    protected static String sanitize(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Iterable) {
            String delim = "";
            StringBuilder buf = new StringBuilder();
            for (Object i : (Iterable)value) {
                buf.append(delim).append(i);
                delim = ", ";
            }
            return buf.toString();
        }
        if (value.getClass().isArray()) {
            String delim = "";
            StringBuilder buf = new StringBuilder();
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                buf.append(delim).append(Array.get(value, i));
                delim = ", ";
            }
            return buf.toString();
        }
        return String.valueOf(value);
    }

    protected static boolean reportErrors(String prefix, List<String> warnings, List<String> errors) {
        for (String msg : warnings) {
            LOGGER.error(prefix + " : " + msg);
        }
        boolean hasErrors = false;
        String fileNotFound = "Input file does not exist: ";
        for (String msg : errors) {
            if (msg.startsWith(fileNotFound) && msg.endsWith("~")) {
                String duplicate = Processor.removeDuplicateMarker((String)msg.substring(fileNotFound.length()));
                LOGGER.error(prefix + " Duplicate path '" + duplicate + "' in Include-Resource");
                continue;
            }
            LOGGER.error(prefix + " : " + msg);
            hasErrors = true;
        }
        return hasErrors;
    }

    static {
        File probe = new File(PROBE_FILE);
        if (probe.isFile()) {
            FileUtils.deleteQuietly((File)probe);
        }
    }

    private static class JarFromClassloader
    extends Jar {
        public JarFromClassloader(ClassPath classpath) {
            super("classrealms");
            ClassPathResource.build(this, classpath, null);
        }
    }
}

