/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import org.wisdom.api.http.Context;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.test.parents.FakeContext;
import org.wisdom.test.parents.Invocation;

public class Action {
    private final Invocation invocation;
    private FakeContext context;

    public Action(Invocation invocation) {
        this.invocation = invocation;
        this.context = new FakeContext();
    }

    public static Action action(Invocation invocation) {
        return new Action(invocation);
    }

    public Action with() {
        return this;
    }

    public Action with(FakeContext context) {
        this.context = context;
        return this;
    }

    public Action parameter(String name, String value) {
        this.context.setParameter(name, value);
        return this;
    }

    public Action body(Object object) {
        this.context.setBody(object);
        return this;
    }

    public Action parameter(String name, int value) {
        this.context.setParameter(name, Integer.toString(value));
        return this;
    }

    public Action parameter(String name, boolean value) {
        this.context.setParameter(name, Boolean.toString(value));
        return this;
    }

    public Action attribute(String name, String value) {
        this.context.setFormField(name, value);
        return this;
    }

    public Action header(String name, String value) {
        this.context.setHeader(name, value);
        return this;
    }

    public ActionResult invoke() {
        Context.CONTEXT.set(this.context);
        try {
            ActionResult actionResult = new ActionResult(this.invocation.invoke(), this.context);
            return actionResult;
        }
        catch (Throwable e) {
            ActionResult actionResult = new ActionResult(Results.internalServerError((Throwable)e), this.context);
            return actionResult;
        }
        finally {
            Context.CONTEXT.remove();
        }
    }

    public static class ActionResult {
        private final Result result;
        private final Context context;

        public ActionResult(Result result, Context context) {
            this.result = result;
            this.context = context;
        }

        public Result getResult() {
            return this.result;
        }

        public Context getContext() {
            return this.context;
        }
    }
}

