/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.wisdom.api.http.FileItem;
import org.wisdom.api.http.MimeTypes;

public class FakeFileItem
implements FileItem {
    private final File file;
    private final String field;

    public FakeFileItem(File file, String field) {
        this.file = file;
        this.field = field;
    }

    public String field() {
        return this.field;
    }

    public String name() {
        return this.file.getName();
    }

    public byte[] bytes() {
        try {
            return FileUtils.readFileToByteArray((File)this.file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public InputStream stream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isInMemory() {
        return false;
    }

    public String mimetype() {
        return MimeTypes.getMimeTypeForFile((File)this.file);
    }

    public long size() {
        return this.file.length();
    }

    public File toFile() {
        return this.file;
    }
}

