/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.wisdom.api.cookies.Cookies;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Request;
import org.wisdom.test.parents.FakeContext;

public class FakeRequest
extends Request {
    private final FakeContext context;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private String uri;
    private HttpMethod method;

    public FakeRequest(FakeContext fakeContext) {
        this.context = fakeContext;
    }

    public FakeRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    public String contentType() {
        return this.context.header("Content-Type");
    }

    public String method() {
        if (this.method == null) {
            return null;
        }
        return this.method.name();
    }

    public String parameter(String name) {
        return this.context.parameter(name);
    }

    public List<String> parameterMultipleValues(String name) {
        return this.context.parameterMultipleValues(name);
    }

    public String parameter(String name, String defaultValue) {
        return this.context.parameter(name, defaultValue);
    }

    public Integer parameterAsInteger(String name) {
        return this.context.parameterAsInteger(name);
    }

    public Integer parameterAsInteger(String name, Integer defaultValue) {
        return this.context.parameterAsInteger(name, defaultValue);
    }

    public Boolean parameterAsBoolean(String name) {
        return this.context.parameterAsBoolean(name);
    }

    public Boolean parameterAsBoolean(String name, boolean defaultValue) {
        return this.context.parameterAsBoolean(name, defaultValue);
    }

    public Map<String, List<String>> parameters() {
        return this.context.parameters();
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public String uri() {
        return this.uri;
    }

    public String remoteAddress() {
        return null;
    }

    public String host() {
        return null;
    }

    public String path() {
        return this.context.path();
    }

    public MediaType mediaType() {
        Collection<MediaType> types = this.mediaTypes();
        if (types == null || types.isEmpty()) {
            return MediaType.ANY_TEXT_TYPE;
        }
        if (types.size() == 1 && types.iterator().next().equals((Object)MediaType.ANY_TYPE)) {
            return MediaType.ANY_TEXT_TYPE;
        }
        return types.iterator().next();
    }

    public Collection<MediaType> mediaTypes() {
        String[] segments;
        String contentType = this.getHeader("Accept");
        if (contentType == null) {
            return ImmutableList.of((Object)MediaType.ANY_TEXT_TYPE);
        }
        TreeSet<MediaType> set = new TreeSet<MediaType>(new Comparator<MediaType>(){

            @Override
            public int compare(MediaType o1, MediaType o2) {
                double q1 = 1.0;
                double q2 = 1.0;
                ImmutableList ql1 = o1.parameters().get((Object)"q");
                ImmutableList ql2 = o2.parameters().get((Object)"q");
                if (ql1 != null && !ql1.isEmpty()) {
                    q1 = Double.parseDouble((String)ql1.get(0));
                }
                if (ql2 != null && !ql2.isEmpty()) {
                    q2 = Double.parseDouble((String)ql2.get(0));
                }
                return new Double(q2).compareTo(q1);
            }
        });
        for (String segment : segments = contentType.split(",")) {
            MediaType type = MediaType.parse((String)segment.trim());
            set.add(type);
        }
        return set;
    }

    public boolean accepts(String mimeType) {
        String contentType = this.getHeader("Accept");
        if (contentType == null) {
            contentType = "text/html";
        }
        if (contentType.contains(mimeType)) {
            return true;
        }
        MediaType input = MediaType.parse((String)mimeType);
        for (MediaType type : this.mediaTypes()) {
            if (!input.is(type)) continue;
            return true;
        }
        return false;
    }

    public Cookies cookies() {
        return this.context.cookies();
    }

    public Map<String, List<String>> headers() {
        return this.context.headers();
    }

    public String encoding() {
        return this.context.header("Accept-Encoding");
    }

    public String language() {
        return this.context.header("Accept-Language");
    }

    public String charset() {
        return this.context.header("Accept-Charset");
    }

    public FakeRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }
}

